package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: MainActionForToolsCouplingImporter.java 4740 2015-01-29 15:33:33Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.3/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/MainActionForToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.MainActionForToolsCoupling;
import fr.inra.agrosyst.services.pz0import.domain.model.MainActionsToolsCouplingImportModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 18/12/14.
 */
public class MainActionForToolsCouplingImporter extends AbstractCSVImporter {

    protected RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDIDao;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(RefInterventionAgrosystTravailEDI.class);

        MainActionsToolsCouplingImportModel model = new MainActionsToolsCouplingImportModel();
        Import<MainActionForToolsCoupling> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (MainActionForToolsCoupling dto : importer) {

            ToolsCoupling toolsCoupling = null;
            if (StringUtils.isNotBlank(dto.getToolsCouplingId())) {
                toolsCoupling = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, dto.getToolsCouplingId());
                if (toolsCoupling == null) {
                    importResults.addErrorLine(line, String.format("ACTION PRINCIPALE IGNORÉE, la combinaison d'outil avec comme identifiant %s n'a n'existe pas ! ", dto.getToolsCouplingId()));
                }
            } else {
                importResults.addErrorLine(line, "ACTION PRINCIPALE IGNORÉE, colonne 'toolscoupling' non renseignée");
            }

            RefInterventionAgrosystTravailEDI mainAction = null;
            if (StringUtils.isNotBlank((dto.getReferenceCode()))) {
                mainAction = refInterventionAgrosystTravailEDIDao.forReference_codeEquals(dto.getReferenceCode()).findUniqueOrNull();
                if (mainAction == null) {
                    importResults.addErrorLine(line, String.format("ACTION PRINCIPALE IGNORÉE, l'action principale avec comme code de référence %s n'existe pas !", dto.getReferenceCode()));
                }
            } else {
                importResults.addErrorLine(line, "ACTION PRINCIPALE IGNORÉE, colonne 'reference_code' non renseignée");
            }


            if (toolsCoupling != null && mainAction != null) {
                toolsCoupling.addMainsActions(mainAction);
                importResults.addInfoLine(line, String.format("ACTION PRINCIPALE %s AJOUTÉE à la combinaison d'outil %s", dto.getReferenceCode(), dto.getToolsCouplingId()));
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
            }

            line++;
        }
        return  importResults;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        refInterventionAgrosystTravailEDIDao = getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
    }
}
