package fr.inra.agrosyst.services.pz0import.domain.dto;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPlanEntryImportDto.java 4607 2014-12-05 21:03:36Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/dto/CroppingPlanEntryImportDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;

import java.util.Collection;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPlanEntryImportDto extends CroppingPlanEntryDto {

    protected String id;
    protected String domainId;

    protected CroppingPlanEntryDto croppingPlanEntryDto;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public CroppingPlanEntryDto getCroppingPlanEntryDto() {
        return croppingPlanEntryDto;
    }

    public void setCroppingPlanEntryDto(CroppingPlanEntryDto croppingPlanEntryDto) {
        this.croppingPlanEntryDto = croppingPlanEntryDto;
    }

    public void addSpecies(CroppingPlanSpeciesDto species) {
        Collection<CroppingPlanSpeciesDto> speciesDtos = croppingPlanEntryDto.getSpecies();
        if (speciesDtos == null) {
            speciesDtos = Lists.newArrayList();
        }
        speciesDtos.add(species);
    }
}
