package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPanEntrySpeciesImporter.java 4677 2014-12-18 12:50:40Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/CroppingPanEntrySpeciesImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CroppingPlanSpecies;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefEspeceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.entities.referential.RefVarieteGevesTopiaDao;

import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanEntryImportDto;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanSpeciesImportDto;
import fr.inra.agrosyst.services.pz0import.domain.model.CroppingPlanSpeciesImportModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPanEntrySpeciesImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(CroppingPanEntrySpeciesImporter.class);
    protected DomainService domainService;
    protected RefVarieteGevesTopiaDao refVarieteGevesesDao;
    protected RefEspeceTopiaDao refEspecesDao;

    @Override
    public ImportResults importFromStream(InputStream is,  Map<String, EntityAndDependencies> entitiesByCsvIds) {

        ImportResults importResults = new ImportResults(CroppingPlanSpecies.class);

        CroppingPlanSpeciesImportModel model = new CroppingPlanSpeciesImportModel();
        Import<CroppingPlanSpeciesImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (CroppingPlanSpeciesImportDto dto : importer) {
            boolean error = false;
            // we use CroppingPlanEntryDto because the service used to save the domain required a collection of this type object.
            CroppingPlanSpeciesDto croppingPlanSpeciesDto = new CroppingPlanSpeciesDto();

            Binder<CroppingPlanSpeciesImportDto, CroppingPlanSpeciesDto> croppingPlanEntryDtoBinder = BinderFactory.newBinder(CroppingPlanSpeciesImportDto.class, CroppingPlanSpeciesDto.class);
            croppingPlanEntryDtoBinder.copy(dto, croppingPlanSpeciesDto);

            dto.setCroppingPlanSpeciesDto(croppingPlanSpeciesDto);

            error = validVariety(importResults, line, croppingPlanSpeciesDto, error);

            error = validSpecies(importResults, line, error, croppingPlanSpeciesDto);

            // set code to manage code affiliation
            croppingPlanSpeciesDto.setCode(csvCodeToAgrosystCode(CroppingPlanEntryDto.class, dto.getCode()));

            // the species must be related to an existing Cropping Plan, if not import faild
            addSpeciesToCropingPlan(importResults, line, dto, error, croppingPlanSpeciesDto);

            line++;
        }
        return  importResults;
    }

    protected void addSpeciesToCropingPlan(ImportResults importResults, Long line, CroppingPlanSpeciesImportDto dto, boolean error, CroppingPlanSpeciesDto croppingPlanSpeciesDto) {
        CroppingPlanEntryImportDto croppingPlanEntryImportDto = (CroppingPlanEntryImportDto) pz0IdToObject.get(CroppingPlanEntryImportDto.class, dto.getCroppingPlanEntryId());
        if (croppingPlanEntryImportDto != null && !error) {
            croppingPlanEntryImportDto.addSpecies(croppingPlanSpeciesDto);
            importResults.addInfoLine(line, "ESPECE VALIDÉE, csvid "+ dto.getId() + ", elle sera persistée avec le domaine: " + croppingPlanEntryImportDto.getDomainId() );
            // the CroppingPlanSpeciesImportDto is push instead of the CroppingPlanSpeciesDto because it carry up more data that the second one
            // and they will probably be use forward into the import process.
            pz0IdToObject.put(CroppingPlanSpeciesImportDto.class, dto.getId(), dto);
            importResults.increaseAddedRecords();
        } else {
            importResults.addErrorLine(line, "ESPECE IGNORÉE, csvid: " + dto.getId());
            importResults.increaseIgnoredRecords();
        }
    }

    protected boolean validSpecies(ImportResults importResults, Long line, boolean error, CroppingPlanSpeciesDto croppingPlanSpeciesDto) {
        String speciesId = croppingPlanSpeciesDto.getSpeciesId();
        if (StringUtils.isNotBlank(speciesId)) {
            RefEspece species = refEspecesDao.forTopiaIdEquals(croppingPlanSpeciesDto.getSpeciesId()).findUniqueOrNull();
            if (species == null) {
                error = true;
                importResults.addErrorLine(line, "L'expèce n'a pas été retrouvée, id: " + speciesId);
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "La colonne species n'est pas rensignée");
        }
        return error;
    }

    protected boolean validVariety(ImportResults importResults, Long line, CroppingPlanSpeciesDto croppingPlanSpeciesDto, boolean error) {
        String varietyId = croppingPlanSpeciesDto.getVarietyId();
        if (StringUtils.isNotBlank(varietyId)) {
            RefVariete variety = refVarieteGevesesDao.forTopiaIdEquals(varietyId).findUniqueOrNull();
            if (variety == null) {
                error = true;
                importResults.addErrorLine(line, "La variété de l'expèce n'a pas été retrouvée, id: " + varietyId);
            }
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        domainService = getServiceFactory().newService(DomainService.class);
        refVarieteGevesesDao = getPersistenceContext().getRefVarieteGevesDao();
        refEspecesDao = getPersistenceContext().getRefEspeceDao();
    }

}
