package fr.inra.agrosyst.services.pz0import;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AbstractAgrosystModelExtended.java 4677 2014-12-18 12:50:40Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/AbstractAgrosystModelExtended.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.Sector;
import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

import java.text.ParseException;

import org.nuiton.csv.ValueParser;

/**
 *
 * @author schellen
 */
public abstract class AbstractAgrosystModelExtended<E> extends AbstractAgrosystModel<E> {

    protected AbstractAgrosystModelExtended(char separator) {
        super(separator);
    }

    /**
     * True/False boolean parser.
     */
    protected static final ValueParser<Boolean> T_F_PARSER = new ValueParser<Boolean>() {
        @Override
        public Boolean parse(String value) throws ParseException {
            Boolean result;
            if ("T".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
                result = Boolean.TRUE;
            } else {
                result = Boolean.FALSE;
            }
            return result;
        }
    };

    protected static final ValueParser<Sector> AGROSYST_SECTOR_PARSER = new ValueParser<Sector>() {
        @Override
        public Sector parse(String value) throws ParseException {
            Sector result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("GRANDES_CULTURES")) {
                    result = Sector.GRANDES_CULTURES;
                } else if (value.equalsIgnoreCase("POLYCULTURE_ELEVAGE")) {
                    result = Sector.POLYCULTURE_ELEVAGE;
                } else if (value.equalsIgnoreCase("VITICULTURE")) {
                    result = Sector.VITICULTURE;
                } else if (value.equalsIgnoreCase("ARBORICULTURE")) {
                    result = Sector.ARBORICULTURE;
                } else if (value.equalsIgnoreCase("MARAICHAGE")) {
                    result = Sector.MARAICHAGE;
                } else if (value.equalsIgnoreCase("HORTICULTURE")) {
                    result = Sector.HORTICULTURE;
                } else if (value.equalsIgnoreCase("CULTURES_TROPICALES")) {
                    result = Sector.CULTURES_TROPICALES;
                } else {
                    throw new UnsupportedOperationException("Filière (growingsystem.sector) non supportée : " + value);
                }
            }
            return result;
        }
    };

    protected static final ValueParser<CategoryStrategy> AGROSYST_CATEGORY_STRATEGY_PARSER = new ValueParser<CategoryStrategy>() {
        @Override
        public CategoryStrategy parse(String value) throws ParseException {
            CategoryStrategy result = null;

            if (!Strings.isNullOrEmpty(value)) {
                if (value.equalsIgnoreCase("EFFICIENCE")) {
                    result = CategoryStrategy.EFFICIENCE;
                } else if (value.equalsIgnoreCase("SUBSTITUTION")) {
                    result = CategoryStrategy.SUBSTITUTION;
                } else if (value.equalsIgnoreCase("RECONCEPTION")) {
                    result = CategoryStrategy.RECONCEPTION;
                } else if (value.equalsIgnoreCase("RECONCEPTION_EFFICIENCE")) {
                    result = CategoryStrategy.RECONCEPTION_EFFICIENCE;
                } else if (value.equalsIgnoreCase("AUTRE")) {
                    result = CategoryStrategy.AUTRE;
                } else {
                    throw new UnsupportedOperationException("Catégorie de stratégie : (growingsystem.categoryStrategy), non supportée : " + value);
                }
            }
            return result;
        }
    };

    protected static final  ValueParser<MaterielWorkRateUnit> WORK_RATE_UNIT_PARSER = new ValueParser<MaterielWorkRateUnit>() {
        @Override
        public MaterielWorkRateUnit parse(String value) throws ParseException {
            MaterielWorkRateUnit result = null;

            if (!Strings.isNullOrEmpty(value)) {
                result = MaterielWorkRateUnit.valueOf(value);
                if (result == null) {
                    throw new UnsupportedOperationException("Unité de débit de chantier, non supportée : " + value);
                }
            }
            return result;
        }
    };

    protected static final ValueParser<Integer> INTEGER_WITH_NULL_AND_9999_PARSER = new ValueParser<Integer>() {
        @Override
        public Integer parse(String value) throws ParseException {
            Integer result = null;
            if (!Strings.isNullOrEmpty(value)) {
                result = Integer.valueOf(value);
                result = new Integer(9999).equals(result) ? null : result;
            }
            return result;
        }
    };

    protected static final ValueParser<Double> DOUBLE_WITH_NULL_AND_9999_PARSER =  new ValueParser<Double>() {
        @Override
        public Double parse(String value) throws ParseException {
            Double result = null;
            if (!value.isEmpty()) {
                // " " est un espace insécable, pas un " "
                result = Double.valueOf(value.replace(',','.').replace(" ", ""));
                result = new Double(9999).equals(result) ? null : result;
            }
            return result;
        }
    };



    protected static final ValueParser<CroppingEntryType> CROPPING_PLAN_ENTRY_TYPE_PARSER =  new ValueParser<CroppingEntryType>() {
        @Override
        public CroppingEntryType parse(String value) throws ParseException {
            CroppingEntryType result = null;
            if ("MAIN".equalsIgnoreCase(value)) {
                result = CroppingEntryType.MAIN;
            } else if ("INTERMEDIATE".equalsIgnoreCase(value)) {
                result = CroppingEntryType.INTERMEDIATE;
            } else if ("CATCH".equalsIgnoreCase(value)) {
                result = CroppingEntryType.CATCH;
            }
            return result;
        }
    };

}
