package fr.inra.agrosyst.services.pz0import.growingsystem;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GrowingSystemImporter.java 4626 2014-12-09 22:38:05Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/growingsystem/GrowingSystemImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingPlanTopiaDao;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgricultureTopiaDao;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemService;
import fr.inra.agrosyst.api.services.pz0.growingSystem.GrowingSystemAndDependencies;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;

import java.io.InputStream;
import java.util.Map;

import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

/**
*
* @author eancelet
* 
* TODO : assurer la filiation des SdC
* 
* TODO le cas échéant :
* * * * ajout des characteritics_growingsystem
* 
* 
*/


public class GrowingSystemImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(GrowingSystemImporter.class);

    private GrowingSystemService growingSystemService;
    protected GrowingPlanTopiaDao growingPlanDao;
    private RefTypeAgricultureTopiaDao refTypeAgricultureDao;
    
    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> growingPlansByCsvIds) {
        ImportResults importResults = new ImportResults(GrowingSystem.class);

        log.debug(String.format("importfromstream"));
        GrowingSystemImportModel model = new GrowingSystemImportModel();
        // récupère le DTO 
        Import<GrowingSystemImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        long line = FIRST_LINE_NUMBER;
        for (GrowingSystemImportDto dto : importer) {
            boolean error = false;
            GrowingSystem growingSystem = growingSystemService.newGrowingSystem();

            Binder<GrowingSystemImportDto, GrowingSystem> growingSystemBinder = BinderFactory.newBinder(GrowingSystemImportDto.class, GrowingSystem.class);
            growingSystemBinder.copyExcluding(dto, growingSystem,
                    GrowingSystem.PROPERTY_TOPIA_ID);

            growingSystem.setCode(csvCodeToAgrosystCode(GrowingSystem.class,  dto.getCode()));

            // valid required fields
            error = validGrowingSystemCode(importResults, line, growingSystem, error);
            error = validGrowingPlanAffiliation(importResults, line, dto, growingSystem, growingPlansByCsvIds, error);
            error = validGrowingSystemName(importResults, line, growingSystem, error);
            error = validGrowingSystemSector(importResults, line, growingSystem, error);
            error = validGrowingSystemUpdateDate(importResults, line, growingSystem, error);

            // Type Agriculture
            String refTypeAgricultureTopiaId = getTypeAgricultureId(importResults, line, dto, growingSystem);

            //saveGrowingSytem(importResults, line, dto, growingSystem, refTypeAgricultureTopiaId);
            if (!error) {
                GrowingSystemAndDependencies growingSystemAndDependencies = new GrowingSystemAndDependencies(growingSystem, refTypeAgricultureTopiaId);
                importResults.addEntity(dto.getId(), growingSystemAndDependencies);
                importResults.addInfoLine(line, "SDC VALIDÉ, csvid: " + dto.getId());
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "SDC IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected String getTypeAgricultureId(ImportResults importResults, long line, GrowingSystemImportDto dto, GrowingSystem growingSystem) {
        String refTypeAgricultureTopiaId = null;
        if (StringUtils.isNotBlank(dto.getTypeAgricultureId())) {
            RefTypeAgriculture refTypeAgriculture = refTypeAgricultureDao.forTopiaIdEquals(dto.getTypeAgricultureId()).findUniqueOrNull();
            if (refTypeAgriculture==null) {
                importResults.addInfoLine(line, String.format("ATTENTION! le Type d'agriculture de topiaId %s n'existe pas en base de données pour le SdC \"%s\".", dto.getTypeAgricultureId(), dto.getName()));
            }
            else {
                refTypeAgricultureTopiaId = refTypeAgriculture.getTopiaId();
                growingSystem.setTypeAgriculture(refTypeAgriculture);
            }
        }
        return refTypeAgricultureTopiaId;
    }

    protected boolean validGrowingPlanAffiliation(ImportResults importResults, long line, GrowingSystemImportDto dto, GrowingSystem growingSystem, Map<String, EntityAndDependencies> growingPlansByCsvIds, boolean error) {
        try {
            if (StringUtils.isNotBlank(dto.getGrowingPlanId())) {
                EntityAndDependencies growingPlaneEntityAndDependencies = growingPlansByCsvIds.get(dto.getGrowingPlanId());
                if (growingPlaneEntityAndDependencies != null) {
                    growingSystem.setGrowingPlan((GrowingPlan) growingPlaneEntityAndDependencies.getEntity());
                } else {
                    importResults.addErrorLine(line, String.format("SDC IGNORÉ!, aucun dispositif n'est retrouvée avec l'identifiant suivant: %s",dto.getGrowingPlanId()));
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, String.format("SDC IGNORÉ!, la colonne 'growingplan' n'est pas renseignée pour le SDC \"%s\"!", dto.getName()));
                error = true;
            }
        } catch (ClassCastException e) {
            importResults.addErrorLine(line, String.format("SDC IGNORÉ!, dispositif non retrouvé pour le SDC \"%s\"!", dto.getName()));
            error = true;
        }
        return error;

    }

    protected boolean validGrowingSystemCode(ImportResults importResults, long line, GrowingSystem growingSystem, boolean error) {
        if (StringUtils.isBlank(growingSystem.getCode())) {
            importResults.addErrorLine(line, "SDC IGNORÉ!, Le code du SDC n'est pas valide.");
            error = true;
        }
        return error;
    }

    protected boolean validGrowingSystemName(ImportResults importResults, long line, GrowingSystem growingSystem, boolean error) {
        if (StringUtils.isBlank(growingSystem.getName())) {
            importResults.addErrorLine(line, "SDC IGNORÉ!, Le nom du SDC n'est pas renseignés.");
            error = true;
        }
        return error;
    }

    protected boolean validGrowingSystemSector(ImportResults importResults, long line, GrowingSystem growingSystem, boolean error) {
        if (growingSystem.getSector() == null) {
            importResults.addErrorLine(line, "SDC IGNORÉ!, secteur n'est pas renseignés.");
            error = true;
        }
        return error;
    }

    protected boolean validGrowingSystemUpdateDate(ImportResults importResults, long line, GrowingSystem growingSystem, boolean error) {
        if (growingSystem.getUpdateDate() == null) {
            importResults.addErrorLine(line, "SDC IGNORÉ!, la date de mise à jour n'est pas renseignés.");
            error = true;
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        refTypeAgricultureDao = getPersistenceContext().getRefTypeAgricultureDao();
        growingPlanDao = getPersistenceContext().getGrowingPlanDao();
        growingSystemService = getServiceFactory().newService(GrowingSystemService.class);
    }

}
