package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: ToolsCouplingImportModel.java 4629 2014-12-10 09:18:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/ToolsCouplingImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.ToolCouplingImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 09/12/14.
 */
public class ToolsCouplingImportModel extends AbstractAgrosystModelExtended<ToolCouplingImportDto> {

    private static final Log log = LogFactory.getLog(ToolsCouplingImportModel.class);

    public ToolsCouplingImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("toolscouplingname", "toolsCouplingName");
        newMandatoryColumn("workforce", "workforce", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("comment", "comment");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("tractor", "tractorId");
        newMandatoryColumn("domain", "domainId");
        newMandatoryColumn("workrate", "workRate", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newIgnoredColumn("workrateunit");
        newMandatoryColumn("transitvolume", "transitVolume", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("manualintervention", "manualIntervention", T_F_PARSER);
    }

    @Override
    public ToolCouplingImportDto newEmptyInstance() {
        return new ToolCouplingImportDto();
    }

}
