package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPlanEntryImportModel.java 4607 2014-12-05 21:03:36Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/CroppingPlanEntryImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanEntryImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPlanEntryImportModel extends AbstractAgrosystModelExtended<CroppingPlanEntryImportDto> {

    private static final Log log = LogFactory.getLog(CroppingPlanEntryImportModel.class);

    public CroppingPlanEntryImportModel() {
        super(';');

        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("domain", "domainId");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", "name");
        newMandatoryColumn("sellingprice", "sellingPrice", DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("type", "type", CROPPING_PLAN_ENTRY_TYPE_PARSER);
    }

    @Override
    public CroppingPlanEntryImportDto newEmptyInstance() {
        return new CroppingPlanEntryImportDto();
    }

}
