package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EquipmentForToolCouplingImporter.java 4629 2014-12-10 09:18:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/EquipmentForToolCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.EquipmentForToolCoupling;
import fr.inra.agrosyst.services.pz0import.domain.model.EquipmentsToolCouplingImportModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 09/12/14.
 */
public class EquipmentForToolCouplingImporter extends AbstractCSVImporter {

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(ImportResults.class);

        EquipmentsToolCouplingImportModel model = new EquipmentsToolCouplingImportModel();
        Import<EquipmentForToolCoupling> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (EquipmentForToolCoupling dto : importer) {

            ToolsCoupling toolsCoupling = null;
            if (StringUtils.isNotBlank(dto.getToolCouplingId())) {
                toolsCoupling = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, dto.getToolCouplingId());
            } else {
                importResults.addErrorLine(line, "colonne 'toolscoupling' non renseignée");
            }

            Equipment equipment = null;
            if (StringUtils.isNotBlank((dto.getEquipmentId()))) {
                equipment = (Equipment) pz0IdToObject.get(Equipment.class, dto.getEquipmentId());
            } else {
                importResults.addErrorLine(line, "colonne 'equipments' non renseignée");
            }

            if (toolsCoupling != null && equipment != null) {
                toolsCoupling.addEquipments(equipment);
                importResults.addInfoLine(line, String.format("EQUIPEMENT %s AJOUTÉ à la combinaison d'outil %s", dto.getToolCouplingId(), dto.getEquipmentId()));
            } else {
                importResults.increaseIgnoredRecords();
            }

            line++;
        }
        return  importResults;
    }
}
