package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPanEntryImporter.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/CroppingPanEntryImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanEntryImportDto;
import fr.inra.agrosyst.services.pz0import.domain.model.CroppingPlanEntryImportModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPanEntryImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(CroppingPanEntryImporter.class);
    protected DomainService domainService;

    @Override
    public ImportResults importFromStream(InputStream is,  Map<String, EntityAndDependencies> entitiesByCsvIds) {

        ImportResults importResults = new ImportResults(CroppingPlanEntryDto.class);

        CroppingPlanEntryImportModel model = new CroppingPlanEntryImportModel();
        Import<CroppingPlanEntryImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (CroppingPlanEntryImportDto dto : importer) {
            boolean error = false;

            // we use CroppingPlanEntryDto because the service used to save the domain required a collection of this type object.
            CroppingPlanEntryDto croppingPlanEntryDto = new CroppingPlanEntryDto();

            Binder<CroppingPlanEntryImportDto, CroppingPlanEntryDto> croppingPlanEntryDtoBinder = BinderFactory.newBinder(CroppingPlanEntryImportDto.class, CroppingPlanEntryDto.class);
            croppingPlanEntryDtoBinder.copy(dto, croppingPlanEntryDto);
            dto.setCroppingPlanEntryDto(croppingPlanEntryDto);

            croppingPlanEntryDto.setCode(csvCodeToAgrosystCode(CroppingPlanEntryDto.class, dto.getCode()));

            error = addCroppingPlanToDomain(importResults, line, dto, error, croppingPlanEntryDto);

            if (!error) {
                importResults.addInfoLine(line, "CULTURE VALIDÉE, csvid: " + dto.getId() + ", elle sera persistée avec le domaine: " + dto.getDomainId());
                pz0IdToObject.put(CroppingPlanEntryImportDto.class, dto.getId(), dto);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CULTURE IGNORÉE, csvid: " + dto.getId());
            }

            line++;
        }
        return  importResults;
    }

    protected boolean addCroppingPlanToDomain(ImportResults importResults, Long line, CroppingPlanEntryImportDto dto, boolean error, CroppingPlanEntryDto croppingPlanEntryDto) {
        String domainId = dto.getDomainId();
        if (StringUtils.isNotBlank(domainId)) {
            DomainAndDependencies domainAndDependencies = (DomainAndDependencies) pz0IdToObject.get(Domain.class, domainId);
            if (domainAndDependencies != null) {
                domainAndDependencies.addCroppingPlanEntryDto(croppingPlanEntryDto);
            } else {
                error = true;
                importResults.addErrorLine(line, "Le domain dont d'identifiant est:" + domainId + " n'a pas été retrouvé.");
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "La colonne 'domain' n'est pas renseignée.");
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        domainService = getServiceFactory().newService(DomainService.class);
    }

}
