/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fr.inra.agrosyst.services.imprt.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: DomainImporter.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/domain/DomainImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainTopiaDao;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.WeatherStation;
import fr.inra.agrosyst.api.entities.WeatherStationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatusTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefLocationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import fr.inra.agrosyst.api.entities.referential.RefOTEXTopiaDao;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.imprt.AbstractCSVImporter;

import java.io.InputStream;

import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

/**
 *
 * @author schellen
 */
public class DomainImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(DomainImporter.class);
    
    private DomainService domainService;
    private DomainTopiaDao domainTopiaDao;
    private RefLocationTopiaDao locationDao;
    private RefLegalStatusTopiaDao refLegalStatusDao;
    private WeatherStationTopiaDao weatherStationDao;
    private RefOTEXTopiaDao refOtexDao;
    private int updatedRecords = 0;
    private int createdRecords = 0;
    private int ignoredRecords = 0;

    public DomainImporter(InputStream is) {
        this.is = is;
    }

    private Domain holdDomainForNaturalId(int campaign, String code) {
        Domain domain = domainTopiaDao.forNaturalId(campaign, code).findUniqueOrNull();
        if (domain == null) {
            domain = domainTopiaDao.newInstance();
            domain.setCampaign(campaign);
            domain.setCode(code);
            
            
            domain.setName("Domaine test Estelle");
            domain.setMainContact("Estelle");
            domain.setType(DomainType.DOMAINE_EXPERIMENTAL);
            
            
            createdRecords++;
        } else {
            updatedRecords++;
        }
        return domain;
    }


    @Override
    public void importFromStream() {

        DomainImportModel model = new DomainImportModel();
        Import<DomainImportDto> importer = Import.newImport(model, is);

        for (DomainImportDto dto : importer) {

            Domain domain = holdDomainForNaturalId(dto.getCampaign(), dto.getCode());
            domainService.createOrUpdateDomain(domain, "fr.inra.agrosyst.api.entities.referential.RefLocation_001036fd-7cba-4b40-8f84-875ea7fa0cd0", null, null, null, null, null, null, null, null, null);/**/
            
/*
            if (!Strings.isNullOrEmpty(dto.getLocationId())) {
                RefLocation location = locationDao.forTopiaIdEquals(dto.getLocationId()).findUniqueOrNull();
                if (location == null) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("DOMAINE IGNORÉ! l'objet RefLocation de topiaId %s n'existe pas en base de données pour le domaine \"%s\".", dto.getLocationId(), dto.getName()));
                    }
                    ignoredRecords++;
                    if (domain.getTopiaId() != null) {
                        updatedRecords--;
                    } else {
                        createdRecords--;
                    }
                    continue;
                }
                domain.setLocation(location);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("DOMAINE IGNORÉ! la colonne reflocation n'est pas renseignée pour le domaine \"%s\"!", dto.getName()));
                }
                ignoredRecords++;
                if (domain.getTopiaId() != null) {
                    updatedRecords--;
                } else {
                    createdRecords--;
                }
                continue;
            }

            
            if (dto.getPartnersNumber() != null && dto.getPartnersNumber()==9999) {
                domain.setPartnersNumber(null);
//                log.debug(String.format("PartnersNumber 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setPartnersNumber(dto.getPartnersNumber());
            }
            
            if (dto.getPermanentEmployeesWorkForce() != null && dto.getPermanentEmployeesWorkForce()==9999) {
                domain.setPermanentEmployeesWorkForce(null);
//                log.debug(String.format("PermanentEmployeesWorkForce 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setPermanentEmployeesWorkForce(dto.getPermanentEmployeesWorkForce());
            }
            
            if (dto.getTemporaryEmployeesWorkForce() != null && dto.getTemporaryEmployeesWorkForce()==9999) {
                domain.setTemporaryEmployeesWorkForce(null);
//                log.debug(String.format("TemporaryEmployeesWorkForce 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setTemporaryEmployeesWorkForce(dto.getTemporaryEmployeesWorkForce());
            }

            if (dto.getOtherWorkForce() != null && dto.getOtherWorkForce()==9999) {
                domain.setOtherWorkForce(null);
//                log.debug(String.format("OtherWorkForce 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setOtherWorkForce(dto.getOtherWorkForce());
            }
            
            if (dto.getFamilyWorkForceWage() != null && dto.getFamilyWorkForceWage()==9999) {
                domain.setFamilyWorkForceWage(null);
//                log.debug(String.format("FamilyWorkForceWage 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setFamilyWorkForceWage(dto.getFamilyWorkForceWage());
            }
            
            if (dto.getWageCosts() != null && dto.getWageCosts()==9999) {
                domain.setWageCosts(null);
//                log.debug(String.format("WageCosts 9999->null pour le domaine \"%s\".", dto.getName()));
            } else {
                domain.setWageCosts(dto.getWageCosts());
            }

            
            if (!Strings.isNullOrEmpty(dto.getLegalStatusId())) {
                RefLegalStatus legalStatus = refLegalStatusDao.forTopiaIdEquals(dto.getLegalStatusId()).findUniqueOrNull();
                if (legalStatus == null && log.isDebugEnabled()) {
                    log.debug(String.format("ATTENTION! le legalStatus de topiaId %s n'existe pas en base de données pour le domaine \"%s\".", dto.getLegalStatus(), dto.getName()));
                }
                domain.setLegalStatus(refLegalStatusDao.forTopiaIdEquals(dto.getLegalStatusId()).findUniqueOrNull());
            }

            if (!Strings.isNullOrEmpty(dto.getDefaultWeatherStationId())) {
                WeatherStation weatherStation = weatherStationDao.forTopiaIdEquals(dto.getDefaultWeatherStationId()).findUniqueOrNull();
                if (weatherStation == null && log.isDebugEnabled()) {
                    log.debug(String.format("ATTENTION! la station par défaut de topiaId %s n'existe pas en base de données pour le domaine \"%s\".", dto.getLegalStatus(), dto.getName()));
                }
                domain.setDefaultWeatherStation(weatherStation);
            }

            if (!Strings.isNullOrEmpty(dto.getRefOtex18Id())) {
                RefOTEX refOtex18 = refOtexDao.forTopiaIdEquals(dto.getRefOtex18Id()).findUniqueOrNull();
                if (refOtex18 == null && log.isDebugEnabled()) {
                    log.debug(String.format("ATTENTION! le Code OTEX de topiaId %s n'existe pas en base de données pour le domaine \"%s\".", dto.getOtex18(), dto.getName()));
                }
                domain.setOtex18(refOtex18);
            }

            if (!Strings.isNullOrEmpty(dto.getRefOtex70Id())) {
                RefOTEX refOtex70 = refOtexDao.forTopiaIdEquals(dto.getRefOtex70Id()).findUniqueOrNull();
                if (refOtex70 == null && log.isDebugEnabled()) {
                    log.debug(String.format("ATTENTION! le Code OTEX de topiaId %s n'existe pas en base de données pour le domaine \"%s\".", dto.getOtex70(), dto.getName()));
                }
                domain.setOtex70(refOtex70);
            }

            domain = domainTopiaDao.update(domain); */

            cacheMap.put(Domain.class, dto.getId(), domain.getTopiaId());

        }
//        getPersistenceContext().commit();

        log.info(String.format("%d domaines ont été crées.", createdRecords));
        log.info(String.format("%d domaines ont été mis à jour.", updatedRecords));
        log.info(String.format("%d domaines ont été ignorés.", ignoredRecords));

    }

    @Override
    public void init(ServiceContext serviceContext, MultiKeyMap cacheMap) {
        super.init(serviceContext, cacheMap);
        domainTopiaDao = getPersistenceContext().getDomainDao();
        domainService = getServiceFactory().newService(DomainService.class);
    }

}
