package fr.inra.agrosyst.services.imprt;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CliServiceContext.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/CliServiceContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystTopiaApplicationContext;
import fr.inra.agrosyst.api.entities.AgrosystTopiaDaoSupplier;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.commons.gson.AgrosystGsonSupplier;
import fr.inra.agrosyst.services.AgrosystConfigurationHelper;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import fr.inra.agrosyst.services.DefaultServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.common.ProjectionHelper;
import fr.inra.agrosyst.services.security.SecurityContext;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.nuiton.topia.persistence.TopiaApplicationContextCache;
import org.nuiton.topia.persistence.TopiaConfigurationConstants;
import org.nuiton.topia.persistence.TopiaTransaction;

/**
 *
 * @author Antoine Schellenberger
 */
public class CliServiceContext implements ServiceContext {

    private static final Log log = LogFactory.getLog(CliServiceContext.class);

    protected static final Long TEST_RUN_ID = System.currentTimeMillis();

    protected Method testMethod;

    protected AgrosystTopiaPersistenceContext transaction;
    protected AgrosystTopiaApplicationContext rootContext;

    protected ServiceFactory serviceFactory;
    protected AgrosystServiceConfig config;

    protected String authenticationToken;
    protected SecurityContext securityContext;
    protected ProjectionHelper projectionHelper;

    public CliServiceContext() {

        this.serviceFactory = new DefaultServiceFactory(this);

        Properties properties = new Properties();
        properties.setProperty(Environment.HBM2DDL_AUTO, "update");
        //properties.setProperty(Environment.SHOW_SQL, "true");
        properties.setProperty(Environment.DIALECT, PostgreSQL9Dialect.class.getName());
        properties.setProperty(Environment.DRIVER, Driver.class.getName());

        String jdbcUrl = "jdbc:postgresql:agrosyst-cli";
        log.debug(String.format("L'URL JDBC utilisée est \"%s\"",jdbcUrl));
        properties.setProperty(Environment.URL, jdbcUrl);
        properties.setProperty(Environment.USER, "agrosyst");
        properties.setProperty(Environment.PASS, "agrosyst");
        properties.setProperty(Environment.CURRENT_SESSION_CONTEXT_CLASS, "thread");

        // add c3p0 pool
        properties.setProperty(Environment.C3P0_MIN_SIZE, "5");
        properties.setProperty(Environment.C3P0_MAX_SIZE, "20");
        properties.setProperty(Environment.C3P0_TIMEOUT, "300");
        properties.setProperty(Environment.C3P0_MAX_STATEMENTS, "50");

        // Topia should not create the schema
        properties.setProperty(TopiaConfigurationConstants.CONFIG_PERSISTENCE_INIT_SCHEMA, "false");

        properties.setProperty(TopiaConfigurationConstants.CONFIG_PERSISTENCE_CLASSES, AgrosystEntityEnum.getImplementationClassesAsString());

        rootContext = TopiaApplicationContextCache.getContext(properties, AgrosystConfigurationHelper.getCreateTopiaContextFunction(getConfig()));
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        if (!Strings.isNullOrEmpty(authenticationToken)) {
            securityContext = null;
        }
    }

    public ServiceFactory getServiceFactory() {
        return serviceFactory;
    }

    @Override
    public ServiceContext newServiceContext() {
        return this;
    }

    @Override
    public void close() {
        // do nothing for test, done by #afterEachTest()
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }

    @Override
    public TopiaTransaction getTransaction() {
        TopiaTransaction result = getTransaction(true);
        return result;
    }

    @Override
    public TopiaTransaction getTransaction(boolean create) {
        AgrosystTopiaPersistenceContext result = getTransaction0(create);
        return result;
    }

    @Override
    public AgrosystTopiaDaoSupplier getDaoSupplier() {
        AgrosystTopiaDaoSupplier result = getTransaction0(true);
        return result;
    }

    @Override
    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        // must stay to false for test, test should not open new transactions
        AgrosystTopiaPersistenceContext result = getTransaction0(false);
        return result;
    }

    @Override
    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        AgrosystTopiaPersistenceContext result = getTransaction0(create);
        return result;
    }

    private AgrosystTopiaPersistenceContext getTransaction0(boolean create) {
        Preconditions.checkState(rootContext != null);

        if (transaction == null && create) {
            transaction = rootContext.newPersistenceContext();
        }
        return transaction;
    }

    @Override
    public <E extends AgrosystService> E newService(Class<E> clazz) {
        return serviceFactory.newService(clazz);
    }

    @Override
    public <I> I newInstance(Class<I> clazz) {
        return serviceFactory.newInstance(clazz);
    }

    @Override
    public AgrosystServiceConfig getConfig() {
        if (config == null) {
            config = new AgrosystServiceConfig("agrosyst-toto.properties");
        }
        return config;
    }
    
    
    

    public void cleanup() {
        if (transaction != null && !transaction.isClosed()) {
            try {
                transaction.rollback();
//                transaction.getHibernateSupport().getHibernateSession().clear();
            } finally {
                transaction.close();
            }
        }
        transaction = null;

        if (!rootContext.isClosed()) {
            rootContext.close();
        }
        serviceFactory = null;
        securityContext = null;
    }
  

    @Override
    public SecurityContext getSecurityContext() {
        if (securityContext == null) {
            securityContext = new SecurityContext(getServiceFactory(), authenticationToken);
        }
        return securityContext;
    }

    @Override
    public SecurityContext getSecurityContextAsUser(String userId) {
        SecurityContext securityContext = new SecurityContext(getServiceFactory(), authenticationToken, userId);
        return securityContext;
    }

    @Override
    public Gson getGson() {
        return new AgrosystGsonSupplier().get();
    }

}
