/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fr.inra.agrosyst.services.imprt;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AbstractCSVImporter.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/AbstractCSVImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;

import java.io.InputStream;

import org.apache.commons.collections4.map.MultiKeyMap;

/**
 *
 * @author Antoine Schellenberger
 */
public abstract class AbstractCSVImporter implements ICsvImporter {

    protected ServiceContext serviceContext;
    protected MultiKeyMap cacheMap;
    protected InputStream is;

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        return serviceContext.getPersistenceContext(create);
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return serviceContext.getPersistenceContext();
    }
    
    public ServiceFactory getServiceFactory() {
        return ((CliServiceContext) serviceContext).getServiceFactory();
    }

    @Override
    public void init(ServiceContext serviceContext, MultiKeyMap cacheMap) {
        this.serviceContext = serviceContext;
        this.cacheMap = cacheMap;        
    }
}
