package fr.inra.agrosyst.services.imprt.domain;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: DomainImportModel.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/domain/DomainImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.services.imprt.AbstractAgrosystModelExtended;

/**
 * Modele d'import des domaines
 * 
 * <ul>
 * <li>Reseau
 * <li>Responsable
 * <li>
 * </ul>
 * 
 * @author Antoine Schellenberger
 */
public class DomainImportModel extends AbstractAgrosystModelExtended<DomainImportDto> {

    public DomainImportModel() {
        super(';');

        newMandatoryColumn("topiaid",DomainImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("campaign", Domain.PROPERTY_CAMPAIGN,INT_PARSER);
        newMandatoryColumn("code",Domain.PROPERTY_CODE);
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", Domain.PROPERTY_NAME);
        newMandatoryColumn("maincontact", Domain.PROPERTY_MAIN_CONTACT);
        newMandatoryColumn("description", Domain.PROPERTY_DESCRIPTION);
        newMandatoryColumn("active", Domain.PROPERTY_ACTIVE,O_N_PARSER);
        newMandatoryColumn("croppingplancomment", Domain.PROPERTY_CROPPING_PLAN_COMMENT);
        newMandatoryColumn("otheractivitiescomment", Domain.PROPERTY_OTHER_ACTIVITIES_COMMENT);
        newMandatoryColumn("statuscomment", Domain.PROPERTY_STATUS_COMMENT);
        newMandatoryColumn("partnersnumber", Domain.PROPERTY_PARTNERS_NUMBER,INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("permanentemployeesworkforce", Domain.PROPERTY_PERMANENT_EMPLOYEES_WORK_FORCE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("temporaryemployeesworkforce", Domain.PROPERTY_TEMPORARY_EMPLOYEES_WORK_FORCE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("otherworkforce", Domain.PROPERTY_OTHER_WORK_FORCE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("familyworkforcewage", Domain.PROPERTY_FAMILY_WORK_FORCE_WAGE,INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("wagecosts", Domain.PROPERTY_WAGE_COSTS,INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("workforcecomment", Domain.PROPERTY_WORKFORCE_COMMENT);
        newMandatoryColumn("cropsworkforce", Domain.PROPERTY_CROPS_WORK_FORCE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("orientation", Domain.PROPERTY_ORIENTATION);
        newMandatoryColumn("usedagriculturalarea", Domain.PROPERTY_USED_AGRICULTURAL_AREA,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("msafee", Domain.PROPERTY_MSA_FEE,DOUBLE_WITH_NULL_PARSER); 
        newMandatoryColumn("averagetenantfarming", Domain.PROPERTY_AVERAGE_TENANT_FARMING,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("decoupledassistance", Domain.PROPERTY_DECOUPLED_ASSISTANCE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("experimentalagriculturalarea", Domain.PROPERTY_EXPERIMENTAL_AGRICULTURAL_AREA,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("homogenizationexperimentalagriculturalarea", Domain.PROPERTY_HOMOGENIZATION_EXPERIMENTAL_AGRICULTURAL_AREA,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("speciestoarea", Domain.PROPERTY_SPECIES_TO_AREA);
        newMandatoryColumn("siret", Domain.PROPERTY_SIRET);
        newMandatoryColumn("validationdate", Domain.PROPERTY_VALIDATION_DATE,DATE_PARSER);
        newMandatoryColumn("validated", Domain.PROPERTY_VALIDATED,O_N_PARSER);
        newMandatoryColumn("updatedate", Domain.PROPERTY_UPDATE_DATE,DATE_PARSER);
        newMandatoryColumn("type", Domain.PROPERTY_TYPE,AGROSYST_DOMAIN_TYPE_PARSER);
        newMandatoryColumn("location", DomainImportDto.PROPERTY_LOCATION_ID);
        newMandatoryColumn("legalstatus", DomainImportDto.PROPERTY_LEGAL_STATUS_ID);
        newMandatoryColumn("zoning", Domain.PROPERTY_ZONING,AGROSYST_ZONING_PARSER);
        newMandatoryColumn("otex18", DomainImportDto.PROPERTY_OTEX18_ID);
        newMandatoryColumn("otex70", DomainImportDto.PROPERTY_OTEX70_ID);
        newMandatoryColumn("defaultweatherstation", DomainImportDto.PROPERTY_DEFAULT_WEATHER_STATION_ID);
    }

    @Override
    public DomainImportDto newEmptyInstance() {
        return new DomainImportDto();
    }
}
