/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package fr.inra.agrosyst.services.imprt;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CliStarter.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.3.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/imprt/CliStarter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.DomainType;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.entities.security.AgrosystUserTopiaDao;
import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.entities.security.UserRole;
import fr.inra.agrosyst.api.entities.security.UserRoleTopiaDao;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.security.AuthenticationService;
import fr.inra.agrosyst.api.services.users.UserDto;
import fr.inra.agrosyst.api.services.users.UserService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.imprt.domain.DomainImporter;
//import fr.inra.agrosyst.services.imprt.growingplan.GrowingPlanImporter;
//import fr.inra.agrosyst.services.imprt.growingsystem.GrowingSystemImporter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.collections4.map.MultiKeyMap;

/**
 *
 * @author antoine Schellenberger
 */
public class CliStarter {

    private final ServiceFactory serviceFactory;
    private final ServiceContext serviceContext;

    public CliStarter() {
        serviceContext = new CliServiceContext();
        serviceFactory = ((CliServiceContext) serviceContext).getServiceFactory();       

    }

    public AgrosystTopiaPersistenceContext getPersistenceContext(boolean create) {
        return serviceContext.getPersistenceContext(create);
    }

    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return serviceContext.getPersistenceContext();
    }

    protected void loginAsAdmin() {

        AgrosystUserTopiaDao userTopiaDao = getPersistenceContext(true).getAgrosystUserDao();
        if (!userTopiaDao.forEmailEquals("admin@test.fr").tryFindAny().isPresent()) {

            UserService userService = serviceFactory.newService(UserService.class);
            UserDto user = new UserDto();
            user.setActive(true);
            user.setEmail("admin@test.fr");
            user.setFirstName("Admin");
            user.setLastName("Test");
            user = userService.createUser(user, "azerty");

            AgrosystUser userEntity = userTopiaDao.forTopiaIdEquals(user.getTopiaId()).findUnique();

            UserRoleTopiaDao userRoleTopiaDao = getPersistenceContext().getUserRoleDao();
            userRoleTopiaDao.create(UserRole.PROPERTY_AGROSYST_USER, userEntity, UserRole.PROPERTY_TYPE, RoleType.ADMIN);

        }

        loginUser("admin@test.fr", "azerty");
    }

    protected UserDto loginUser(String login, String password) {

        AuthenticationService authenticationService = serviceFactory.newService(AuthenticationService.class);

        UserDto authUser = authenticationService.login(login, password);
        ((CliServiceContext) serviceContext).setAuthenticationToken(authUser.getAuthenticationToken());

        return authUser;
    }

    public void start() {
        loginAsAdmin();

        MultiKeyMap cacheMap = new MultiKeyMap();  

           
        try {
            List<ICsvImporter> importers = new LinkedList<ICsvImporter>();
            importers.add(new DomainImporter(new FileInputStream("/home/eancelet/Agrosyst/Imports_ETL/essai_pz/NMJ/domain_NMJ.csv")));
//            importers.add(new GrowingPlanImporter(new FileInputStream("/home/eancelet/Agrosyst/Imports_ETL/essai_pz/NMJ/growingplan_NMJ.csv")));
//            importers.add(new GrowingSystemImporter(new FileInputStream("/home/eancelet/Agrosyst/Imports_ETL/essai_pz/NMJ/growingsystem_NMJ.csv")));

            for (ICsvImporter csvImporter : importers) {
                csvImporter.init(serviceContext, cacheMap);
                csvImporter.importFromStream();
            }
            getPersistenceContext().commit();

        } catch (FileNotFoundException ex) {
            getPersistenceContext().rollback();
            Logger.getLogger(CliStarter.class.getName()).log(Level.SEVERE, null, ex);
        } catch (Exception e) {
            getPersistenceContext().rollback();
            System.out.println("rollback");
        }

        ((CliServiceContext) serviceContext).cleanup();
    }

    public static void main(String[] args) {
        CliStarter importer = new CliStarter();
        importer.start();
    }

}
