package fr.inra.agrosyst.api.services.users;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Users.java 4420 2014-10-14 12:34:46Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/users/Users.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.security.AgrosystUser;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class Users {

    public static final Function<AgrosystUser, UserDto> TO_USER_DTO = new Function<AgrosystUser, UserDto>() {
        @Override
        public UserDto apply(AgrosystUser input) {
            UserDto result;
            if (input == null) {
                result = null;
            } else {
                result = new UserDto();
                result.setTopiaId(input.getTopiaId());
                result.setFirstName(input.getFirstName());
                result.setLastName(input.getLastName());
                result.setEmail(input.getEmail());
                result.setOrganisation(input.getOrganisation());
                result.setPhoneNumber(input.getPhoneNumber());
                result.setBanner(input.getBanner());
                result.setActive(input.isActive());
                result.setAcceptedCharter(input.getCharterVersion() != null && input.getCharterVersion() == CURRENT_CHART_VERSION);
                result.setLastMessageReadDate(input.getLastMessageReadDate());
            }
            return result;
        }
    };

    public static final int CURRENT_CHART_VERSION = 2;

}
