package fr.inra.agrosyst.api.services.users;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UserService.java 4440 2014-10-16 17:25:26Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/users/UserService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.referential.ImportResult;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Service to manage users
 *
 * @author cosse
 */
public interface UserService extends AgrosystService {

    boolean isEmailInUse(String email, String currentUserId);

    UserDto createUser(UserDto user, String password);

    UserDto getUser(String topiaId);

    UserDto updateUser(UserDto user, String password);

    void unactivateUsers(Set<String> topiaIds, boolean activate);

    ResultList<UserDto> getFilteredUsers(UserFilter userFilter, boolean includeRoles);

    /**
     * Return all Users with there first name or last name as there name contains the research term.
     * @param research The researched term.
     * @param nbResult The maximum number if return result
     * @return All the users with there first name or last name as there name contains the research term.
     */
    List<UserDto> getNameFilteredActiveUsers(String research, Integer nbResult);


    /**
     * return the number of users
     * @return The number of users
     * @param active optional active filter (may be null)
     */
    long getUsersCount(Boolean active);

    /**
     * Generate a password reminder token and sends the reminder email
     *
     * @param email
     * @return {@code true} if email was found and email sent
     */
    boolean askForPasswordReminder(String email);

    UserDto preparePasswordChange(String token, String userId);

    boolean updatePassword(String token, String userId, String password);

    void sendFeedback(String env, String location, String locationTitle, String category, String feedback, String requested, String referer, byte[] screenshotData);

    /**
     * Import user file from string.
     * 
     * @param userFileStream user file stream
     * @return import result
     */
    ImportResult importUsers(InputStream userFileStream);

    UserDto acceptCharter();

    UserDto readInfoMessages(Date lastMessageReadDate);
}
