package fr.inra.agrosyst.api.services.users;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UserDto.java 4420 2014-10-14 12:34:46Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/users/UserDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.security.RoleType;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UserDto implements Serializable {

    private static final long serialVersionUID = 7686475296514942572L;

    protected String topiaId;
    protected String firstName;
    protected String lastName;
    protected String email;
    protected String organisation;
    protected String phoneNumber;
    protected String banner;
    protected boolean active;
    protected Set<RoleType> roles;
    protected String authenticationToken;
    protected boolean acceptedCharter;
    protected Date lastMessageReadDate;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrganisation() {
        return organisation;
    }

    public Date getLastMessageReadDate() {
        return lastMessageReadDate;
    }

    public void setLastMessageReadDate(Date lastMessageReadDate) {
        this.lastMessageReadDate = lastMessageReadDate;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getBanner() {
        return banner;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<RoleType> getRoles() {
        return roles;
    }

    public void setRoles(Set<RoleType> roles) {
        this.roles = roles;
    }

    public String getAuthenticationToken() {
        return authenticationToken;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    public boolean isAcceptedCharter() {
        return acceptedCharter;
    }

    public void setAcceptedCharter(boolean acceptedCharter) {
        this.acceptedCharter = acceptedCharter;
    }
}
