package fr.inra.agrosyst.api.services.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UserRoleEntityDto.java 3369 2014-02-20 15:27:52Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/security/UserRoleEntityDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import com.google.common.base.Objects;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UserRoleEntityDto implements Serializable {

    private static final long serialVersionUID = -8398311239355356838L;

    protected String identifier;
    protected String label;
    protected Integer campaign;

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getCampaign() {
        return campaign;
    }

    public void setCampaign(Integer campaign) {
        this.campaign = campaign;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this)
                .add("identifier", identifier)
                .add("label", label)
                .add("campaign", campaign).toString();
    }
}
