package fr.inra.agrosyst.api.services.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UserRoleDto.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/security/UserRoleDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import com.google.common.base.MoreObjects;

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class UserRoleDto implements Serializable {

    private static final long serialVersionUID = 6913557761704438621L;

    protected String topiaId;
    protected RoleType type;

    protected UserDto user;
    protected UserRoleEntityDto entity;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public RoleType getType() {
        return type;
    }

    public void setType(RoleType type) {
        this.type = type;
    }

    public UserRoleEntityDto getEntity() {
        return entity;
    }

    public void setEntity(UserRoleEntityDto entity) {
        this.entity = entity;
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto user) {
        this.user = user;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("topiaId", topiaId)
                .add("type", type)
                .add("user", user)
                .add("entity", entity).toString();
    }

}
