package fr.inra.agrosyst.api.services.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: AuthorizationService.java 4903 2015-04-22 09:34:29Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/security/AuthorizationService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.security.RoleType;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.referential.ImportResult;
import fr.inra.agrosyst.api.services.users.UserDto;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public interface AuthorizationService extends AgrosystService {

    boolean isAdmin(String authenticationToken);

    boolean isIsDataProcessor(String authenticationToken);

    boolean canCreateUser(String authenticationToken);

    void dropComputedPermissions(String authenticationToken);

    String checkComputedPermissions(String authenticationToken);

    String checkComputedPermissions(String authenticationToken, String doAsUserId);

    List<UserRoleDto> getUserRoles(String userId);

    List<UserRoleDto> getEntityRoles(RoleType roleType, String entityCode);

    List<UserRoleEntityDto> searchPossibleEntities(RoleType roleType, String termRaw);

    List<UserRoleEntityDto> searchEntities(RoleType roleType, String termRaw, Integer campaign);

    /**
     * Set roles to the user with id the userId given has parameter. Previous roles are removed.
     * @param userId
     * @param userRoles
     */
    void saveUserRoles(String userId, List<UserRoleDto> userRoles);

    void saveEntityUserRoles(RoleType roleType, String entityCode, List<UserRoleDto> roles);

    List<UserDto> getDomainResponsibles(String domainCode);

    List<UserDto> getGrowingPlanResponsibles(String growingPlanCode);

    /**
     * Import rules files
     * @param userFileStream
     * @return
     */
    ImportResult importRoles(InputStream userFileStream);

    /**
     * Add role to the user with id the given userId
     * @param userId user Id
     * @param userRoles roles to add
     */
    void addUserRoles(String userId, List<UserRoleDto> userRoles);

    /**
     *
     * @param allResults
     */
    void importPz0UsersRoles(Map<Class, ImportResults> allResults);
}
