package fr.inra.agrosyst.api.services.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: AuthenticationService.java 3396 2014-02-21 14:22:49Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/security/AuthenticationService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.users.UserDto;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public interface AuthenticationService extends AgrosystService {

    /**
     * Test l'authentification de l'utilisateur et charge l'entité User
     *
     * @param email    The user's email
     * @param password The user's password
     * @return l'utilisateur
     */
    UserDto login(String email, String password);

    void logout(String token);

    String getAuthenticatedUserId(String token);

    UserDto getAuthenticatedUser(String token);

    long getConnectedUsersCount();

}
