package fr.inra.agrosyst.api.services.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: AnonymizeService.java 3921 2014-03-31 11:03:47Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/security/AnonymizeService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.base.Function;

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GeoPoint;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.domain.DomainDto;
import fr.inra.agrosyst.api.services.domain.PlotDto;
import fr.inra.agrosyst.api.services.domain.ZoneDto;
import fr.inra.agrosyst.api.services.growingplan.GrowingPlanDto;
import fr.inra.agrosyst.api.services.growingsystem.GrowingSystemDto;
import fr.inra.agrosyst.api.services.performance.PerformanceDto;
import fr.inra.agrosyst.api.services.practiced.PracticedPlotDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemDto;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 * @since 0.8
 */
public interface AnonymizeService extends AgrosystService {

    String anonymize(String clear);

    Domain checkForDomainAnonymization(Domain domain);

    Collection<Domain> checkForDomainsAnonymization(Collection<Domain> domains);

    ResultList<Domain> checkForDomainsAnonymization(ResultList<Domain> domains);

    Function<Domain, DomainDto> getDomainToDtoFunction(boolean includeResponsibles);

    Map<String,String> getDomainsAsMap(Iterable<Domain> domains);

    List<GeoPoint> checkForGeoPointAnonymization(List<GeoPoint> result);

    Plot checkForPlotAnonymization(Plot plot);

    List<Plot> checkForPlotsAnonymization(List<Plot> plots);

    Function<Plot, PlotDto> getPlotToDtoFunction();

    Zone checkForZoneAnonymization(Zone zone);

    Function<Zone, ZoneDto> getZoneToDtoFunction();

    Function<Zone, ZoneDto> getZoneToDtoFunction(boolean includePlot);

    GrowingPlan checkForGrowingPlanAnonymization(GrowingPlan growingPlan);

    Function<GrowingPlan, GrowingPlanDto> getGrowingPlanToDtoFunction(boolean includeResponsibles);

    Map<String,String> getGrowingPlansAsMap(Iterable<GrowingPlan> growingPlans);

    GrowingSystem checkForGrowingSystemAnonymization(GrowingSystem growingSystem);

    Function<GrowingSystem, GrowingSystemDto> getGrowingSystemToDtoFunction();

    PracticedSystem checkForPracticedSystemAnonymization(PracticedSystem practicedSystem);

    Function<PracticedSystem, PracticedSystemDto> getPracticedSystemToDtoFunction();

    ManagementMode checkForManagementModeAnonymization(ManagementMode managementMode);

    Function<PracticedPlot,PracticedPlotDto> getPracticedPlotToDtoFunction();

    ResultList<Performance> checkForPerformancesAnonymization(ResultList<Performance> result);

    Function<Performance,PerformanceDto> getPerformanceToDtoFunction();
}
