package fr.inra.agrosyst.api.services.referential;

/*
 * #%L
 * Agrosyst :: API
 * $Id: TypeMaterielFilter.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/referential/TypeMaterielFilter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

import fr.inra.agrosyst.api.entities.MaterielType;

/**
 * Filtre utilisé pour obtenir les différents types de materiels disponibles (par entonoir) dans
 * le but de sélectionner un matériel.
 * 
 * @author Eric Chatellier
 */
public class TypeMaterielFilter implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7909969860998322126L;

    protected MaterielType type;

    protected String typeMateriel1;
    
    protected String typeMateriel2;
    
    protected String typeMateriel3;
    
    protected String typeMateriel4;

    protected double uniteParAn;

    public TypeMaterielFilter() {

    }

    public TypeMaterielFilter(String typeMateriel1) {
        this();
        this.typeMateriel1 = typeMateriel1;
    }

    public TypeMaterielFilter(String typeMateriel1, String typeMateriel2) {
        this(typeMateriel1);
        this.typeMateriel2 = typeMateriel2;
    }

    public TypeMaterielFilter(String typeMateriel1, String typeMateriel2, String typeMateriel3) {
        this(typeMateriel1, typeMateriel2);
        this.typeMateriel3 = typeMateriel3;
    }

    public TypeMaterielFilter(String typeMateriel1, String typeMateriel2, String typeMateriel3, String typeMateriel4) {
        this(typeMateriel1, typeMateriel2, typeMateriel3);
        this.typeMateriel4 = typeMateriel4;
    }

    public MaterielType getType() {
        return type;
    }

    public void setType(MaterielType type) {
        this.type = type;
    }

    public String getTypeMateriel1() {
        return typeMateriel1;
    }

    public void setTypeMateriel1(String typeMateriel1) {
        this.typeMateriel1 = typeMateriel1;
    }

    public String getTypeMateriel2() {
        return typeMateriel2;
    }

    public void setTypeMateriel2(String typeMateriel2) {
        this.typeMateriel2 = typeMateriel2;
    }

    public String getTypeMateriel3() {
        return typeMateriel3;
    }

    public void setTypeMateriel3(String typeMateriel3) {
        this.typeMateriel3 = typeMateriel3;
    }

    public String getTypeMateriel4() {
        return typeMateriel4;
    }

    public void setTypeMateriel4(String typeMateriel4) {
        this.typeMateriel4 = typeMateriel4;
    }

    public double getUniteParAn() {
        return uniteParAn;
    }

    public void setUniteParAn(double uniteParAn) {
        this.uniteParAn = uniteParAn;
    }
}
