package fr.inra.agrosyst.api.services.referential;

/*
 * #%L
 * Agrosyst :: API
 * $Id: MineralProductType.java 2861 2014-01-24 10:20:46Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/referential/MineralProductType.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;

import com.google.common.collect.Lists;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class MineralProductType implements Serializable {

    private static final long serialVersionUID = -1508993768028145707L;

    protected int categ;
    protected String label;
    protected List<String> shapes;

    public MineralProductType(Integer categ, String label, String shape) {
        this.categ = categ;
        this.label = label;
        this.shapes = Lists.newArrayList(shape);
    }

    public int getCateg() {
        return categ;
    }

    public void setCateg(int categ) {
        this.categ = categ;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<String> getShapes() {
        return shapes;
    }

    public void setShapes(List<String> shapes) {
        this.shapes = shapes;
    }
}
