package fr.inra.agrosyst.api.services.referential;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ImportResult.java 4612 2014-12-06 18:43:48Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/referential/ImportResult.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;
import java.util.List;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;

/**
 * @author Arnaud Thimel : thimel@codelutin.com
 */
public class ImportResult implements Serializable {

    private static final long serialVersionUID = -6928906011743267261L;

    protected int created;
    protected int updated;
    protected int deleted;
    protected int ignored;
    protected long duration;
    protected List<String> errors = Lists.newArrayList();

    public void incCreated() {
        created++;
    }

    public void incUpdated() {
        updated++;
    }

    public void incDeleted() {
        deleted++;
    }

    public void incIgnored() {
        ignored++;
    }

    public int getCreated() {
        return created;
    }

    public void setCreated(int created) {
        this.created = created;
    }

    public int getUpdated() {
        return updated;
    }

    public void setUpdated(int updated) {
        this.updated = updated;
    }

    public int getDeleted() {
        return deleted;
    }

    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    public int getIgnored() {
        return ignored;
    }

    public void setIgnored(int ignored) {
        this.ignored = ignored;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    public List<String> getErrors() {
        return errors;
    }

    public void addError(String error) {
        errors.add(error);
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @Override
    public String toString() {
        String result = MoreObjects.toStringHelper(this)
                .add("created", created)
                .add("updated", updated)
                .add("deleted", deleted)
                .add("ignored", ignored)
                .add("duration", duration + "ms")
                .add("errors", errors.size())
                .toString();
        return result;
    }

}
