package fr.inra.agrosyst.api.services.referential;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ExportService.java 3270 2014-02-17 11:08:03Z echatellier $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/referential/ExportService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.InputStream;
import java.util.List;

import fr.inra.agrosyst.api.services.AgrosystService;

/**
 * Referentiel service.
 *
 * @author Eric Chatellier
 */
public interface ExportService extends AgrosystService {

    /**
     * Export selected entity ids as csv.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportSolArvalisCSV(Iterable<String> entityIds);

    /**
     * Export selected entity ids as csv.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportOrientationEdiCSV(Iterable<String> entityIds);
    
    /**
     * Export des materiels tracteurs au format csv.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportMaterielTracteursCSV(Iterable<String> entityIds);

    /**
     * Export des materiels automoteurs au format csv.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportMaterielAutomoteursCSV(Iterable<String> entityIds);

    /**
     * Export des materiels outils au format csv.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportMaterielOutilsCSV(Iterable<String> entityIds);

    /**
     * Export des materiels migration au format csv.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportMaterielIrrigationCSV(Iterable<String> entityIds);

    /**
     * Import des statuts juridiques.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportLegalStatusCSV(Iterable<String> entityIds);

    InputStream exportEspeces(Iterable<String> entityIds);

    InputStream exportVarietesGeves(Iterable<String> entityIds);

    InputStream exportVarietesPlantGrape(Iterable<String> entityIds);

    InputStream exportClonesPlantGrape(Iterable<String> entityIds);

    InputStream exportEspecesToVarietes(Iterable<String> entityIds);

    /**
     * Export du référentiel OTEX au format csv.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportOtexCSV(Iterable<String> entityIds);

    InputStream exportInterventionAgrosystTravailEdiCSV(Iterable<String> entityIds);

    InputStream exportTypeTravailEdiCSV(Iterable<String> entityIds);

    InputStream exportStadesEdiCSV(Iterable<String> entityIds);

    /**
     * Export du référentiel sol texture geppa.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportSolTextureGeppa(Iterable<String> entityIds);

    /**
     * Export du référentiel zonage parcelle edi.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportZonageParcelleEdi(Iterable<String> entityIds);

    /**
     * Export du référentiel sol profondeur indigo.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportSolProfondeurIndigo(Iterable<String> entityIds);

    /**
     * Export du référentiel sol caracteristiques indigo.
     * 
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportSolCarateristiquesIndigo(Iterable<String> entityIds);

    /**
     * Export du référentiel unitesEDI.
     *
     * @param entityIds entity to export
     * @return csv export ex stream
     */
    InputStream exportUniteEDI(Iterable<String> entityIds);

    /**
     * Export du référentiel FertiMinUNIFA
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportFertiMinUNIFA(Iterable<String> entityIds);
    
    /**
     * Export du référentiel Adventices.
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportAdventices(Iterable<String> entityIds);

    /**
     * Export du référentiel NuisiblesEDI.
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportNuisiblesEDI(Iterable<String> entityIds);

    /**
     * Export du référentiel Ferti orga.
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportFertiOrga(Iterable<String> entityIds);

    /**
     * Export du référentiel Ferti_engraisorg.
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportFertiEngraisOrg(Iterable<String> entityIds);

    /**
     * Export du référentiel station meteo.
     * @param entityIds entity to export
     * @return csv export
     */
    InputStream exportStationMeteo(Iterable<String> entityIds);

    InputStream exportGesCarburants(Iterable<String> entityIds);

    InputStream exportGesEngrais(Iterable<String> entityIds);

    InputStream exportGesPhyto(Iterable<String> entityIds);

    InputStream exportGesSemences(Iterable<String> entityIds);

    InputStream exportNrjCarburants(Iterable<String> entityIds);

    InputStream exportNrjEngrais(Iterable<String> entityIds);

    InputStream exportNrjPhyto(Iterable<String> entityIds);

    InputStream exportNrjSemences(Iterable<String> entityIds);

    InputStream exportNrjGesOutils(Iterable<String> entityIds);
    
    InputStream exportMesure(Iterable<String> entityIds);
    
    InputStream exportSupportOrganeEDI(Iterable<String> entityIds);
    
    InputStream exportStadeNuisibleEDI(Iterable<String> entityIds);
    
    InputStream exportTypeNotationEDI(Iterable<String> entityIds);
    
    InputStream exportValeurQualitativeEDI(Iterable<String> entityIds);
    
    InputStream exportUnitesQualifiantEDI(Iterable<String> entityIds);

    InputStream exportActaTraitementsProducts(Iterable<String> entityIds);
    
    InputStream exportActaSubstanceActive(Iterable<String> entityIds);
    
    InputStream exportProtocoleVgObs(Iterable<String> entityIds);
    
    InputStream exportElementVoisinage(Iterable<String> entityIds);

    InputStream exportPhytoSubstanceActiveIphy(Iterable<String> entityIds);

    InputStream exportTypeAgriculture(Iterable<String> entityIds);

    InputStream exportActaDosageSpc(Iterable<String> entityIds);

    InputStream exportActaGroupeCultures(Iterable<String> entityIds);

    InputStream exportLienCulturesEdiActa(Iterable<String> entityIds);

    InputStream exportSaActaIphy(Iterable<String> entityIds);

    InputStream exportTraitSdC(Iterable<String> entityIds);

    InputStream exportCultureEdiGroupeCouvSol(Iterable<String> entityIds);

    InputStream exportCouvSolPerenne(Iterable<String> entityIds);

    InputStream exportCouvSolAnnuelle(Iterable<String> entityIds);

    InputStream exportActaTraitementsProductsCateg(List<String> entityIds);

    InputStream exportZoneClimatiqueIphy(List<String> entityIds);
}
