package fr.inra.agrosyst.api.services.pz0.security;

/*
 * #%L
 * Agrosyst :: API
 * $Id: UsersRolesAndDependencies.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/security/UsersRolesAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.security.UserRoleDto;

import java.util.List;
import java.util.Map;

public class UsersRolesAndDependencies extends EntityAndDependencies {

    protected Map<String, List<UserRoleDto>> usersRoles = Maps.newHashMap();


    public UsersRolesAndDependencies() {
        super(null);
    }

    public void addUserRole(String userId, UserRoleDto userRoleDto) {
        List<UserRoleDto> userRoleDtos = usersRoles.get(userId);
        if (userRoleDtos == null) {
            userRoleDtos = Lists.newArrayList();
            usersRoles.put(userId, userRoleDtos);
        }
        userRoleDtos.add(userRoleDto);
    }

    public Map<String, List<UserRoleDto>> getUsersRoles() {
        return usersRoles;
    }
}
