package fr.inra.agrosyst.api.services.pz0.practicedSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0PracticedSeasonalCropCycle.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedSystem/Pz0PracticedSeasonalCropCycle.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;

import java.util.List;

/**
 * Created by davidcosse on 23/04/15.
 */
public class Pz0PracticedSeasonalCropCycle {

    protected String csvId;
    protected String practicedSystemId;
    protected PracticedSeasonalCropCycleDto practicedSeasonalCropCycleDto;

    protected List<Pz0PracticedCropCycleConnection> pz0Connections = Lists.newArrayList();
    protected List<Pz0PracticedCropCycleNode> pz0Nodes = Lists.newArrayList();

    public Pz0PracticedSeasonalCropCycle(String csvId) {
        this.csvId = csvId;
        practicedSeasonalCropCycleDto = new PracticedSeasonalCropCycleDto();
    }

    public void addPz0Connection(Pz0PracticedCropCycleConnection pz0Connection) {
        pz0Connections.add(pz0Connection);
        practicedSeasonalCropCycleDto.addConnection(pz0Connection.getPracticedCropCycleConnectionDto());
    }

    public void addPz0Node(Pz0PracticedCropCycleNode pz0Node) {
        pz0Nodes.add(pz0Node);
        practicedSeasonalCropCycleDto.addNode(pz0Node.getNodeDto());
    }

    public String getCsvId() {
        return csvId;
    }

    public PracticedSeasonalCropCycleDto getPracticedSeasonalCropCycleDto() {
        return practicedSeasonalCropCycleDto;
    }

    public List<Pz0PracticedCropCycleConnection> getPz0Connections() {
        return pz0Connections;
    }

    public List<Pz0PracticedCropCycleNode> getPz0Nodes() {
        return pz0Nodes;
    }

    public String getPracticedSystemId() {
        return practicedSystemId;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }
}
