package fr.inra.agrosyst.api.services.pz0.practicedSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0PracticedPerennialCropCycle.java 4977 2015-06-11 04:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedSystem/Pz0PracticedPerennialCropCycle.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.practiced.PracticedPerennialCropCycleDto;

import java.util.Map;

/**
 * Created by davidcosse on 23/04/15.
 */
public class Pz0PracticedPerennialCropCycle {

    protected String csvId;
    protected String practicedSystemId;
    protected String pz0CropCode;

    protected PracticedPerennialCropCycleDto practicedPerennialCropCycleDto;

    protected Map<String, Pz0PracticedCropCyclePhase> phasesByCsvId = Maps.newHashMap();

    public Pz0PracticedPerennialCropCycle(String csvId, String pz0CropCode) {
        this.csvId = csvId;
        this.pz0CropCode = pz0CropCode;
        this.practicedPerennialCropCycleDto = new PracticedPerennialCropCycleDto();
    }

    public void addPz0Phase(Pz0PracticedCropCyclePhase pz0Phase) {
        phasesByCsvId.put(pz0Phase.getCsvId(), pz0Phase);
        practicedPerennialCropCycleDto.addCropCyclePhaseDtos(pz0Phase.getPhaseDto());
    }


    public String getCsvId() {
        return csvId;
    }

    public PracticedPerennialCropCycleDto getPracticedPerennialCropCycleDto() {
        return practicedPerennialCropCycleDto;
    }

    public Map<String, Pz0PracticedCropCyclePhase> getPz0PhasesByCsvId() {
        return phasesByCsvId;
    }

    public String getPz0CropCode() {
        return pz0CropCode;
    }

    public String getPracticedSystemId() {
        return practicedSystemId;
    }

    public void setPracticedSystemId(String practicedSystemId) {
        this.practicedSystemId = practicedSystemId;
    }
}
