package fr.inra.agrosyst.api.services.pz0.practicedSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0PracticedCropCyclePhase.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedSystem/Pz0PracticedCropCyclePhase.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;

import java.util.Map;

/**
 * Created by davidcosse on 23/04/15.
 */
public class Pz0PracticedCropCyclePhase {

    protected String csvId;
    protected PracticedCropCyclePhaseDto phaseDto;
    protected String practicedPerennialCropCycleId;

    protected Map<String, Pz0PracticedIntervention> pz0InterventionByCsvId = Maps.newHashMap();

    public Pz0PracticedCropCyclePhase(String csvId, String practicedPerennialCropCycleId) {
        this.csvId = csvId;
        this.practicedPerennialCropCycleId = practicedPerennialCropCycleId;
        phaseDto = new PracticedCropCyclePhaseDto();
    }

    public void addPracticedPz0Intervention(Pz0PracticedIntervention pz0Intervention) {
        pz0InterventionByCsvId.put(pz0Intervention.getCsvId(), pz0Intervention);
        phaseDto.addIntervention(pz0Intervention.getPracticedInterventionDto());
    }

    public String getCsvId() {
        return csvId;
    }

    public PracticedCropCyclePhaseDto getPhaseDto() {
        return phaseDto;
    }

    public Map<String, Pz0PracticedIntervention> getPz0InterventionByCsvId() {
        return pz0InterventionByCsvId;
    }

    public String getPracticedPerennialCropCycleId() {
        return practicedPerennialCropCycleId;
    }
}
