package fr.inra.agrosyst.api.services.pz0.practicedSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0PracticedCropCycleConnection.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedSystem/Pz0PracticedCropCycleConnection.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;

import java.util.Map;

/**
 * Created by davidcosse on 23/04/15.
 */
public class Pz0PracticedCropCycleConnection {

    protected String csvId;
    protected String pz0NodeId;
    protected PracticedCropCycleConnectionDto practicedCropCycleConnectionDto;
    protected Map<String, Pz0PracticedIntervention> pz0InterventionByCsvId = Maps.newHashMap();

    public Pz0PracticedCropCycleConnection(String csvId, String pz0NodeId) {
        this.csvId = csvId;
        this.pz0NodeId = pz0NodeId;
        practicedCropCycleConnectionDto = new PracticedCropCycleConnectionDto();
    }

    public void addPracticedPz0Intervention(Pz0PracticedIntervention pz0Intervention) {
        pz0InterventionByCsvId.put(pz0Intervention.getCsvId(), pz0Intervention);
        practicedCropCycleConnectionDto.addIntervention(pz0Intervention.getPracticedInterventionDto());
    }

    public String getCsvId() {
        return csvId;
    }

    public PracticedCropCycleConnectionDto getPracticedCropCycleConnectionDto() {
        return practicedCropCycleConnectionDto;
    }

    public String getPz0NodeId() {
        return pz0NodeId;
    }

    public Map<String, Pz0PracticedIntervention> getPz0InterventionByCsvId() {
        return pz0InterventionByCsvId;
    }
}
