package fr.inra.agrosyst.api.services.pz0.practicedSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedSystemAndDependencies.java 5025 2015-07-08 09:05:25Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedSystem/PracticedSystemAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;

import java.util.List;

/**
 * Created by davidcosse on 17/12/14.
 */
public class PracticedSystemAndDependencies extends EntityAndDependencies {

    protected long importedNumber;
    protected String csvId;
    protected List<Pz0PracticedPerennialCropCycle> pz0PracticedPerennialCropCycles = Lists.newArrayList();
    protected List<Pz0PracticedSeasonalCropCycle> pz0PracticedSeasonalCropCycles = Lists.newArrayList();
    protected List<Price> prices = Lists.newArrayList();

    /**
     *
     * @param entity the entity to persist
     * @param importedNumber the position in csv file
     */
    public PracticedSystemAndDependencies(PracticedSystem entity, long importedNumber, String csvId) {
        super(entity);
        this.importedNumber = importedNumber;
        this.csvId = csvId;
    }

    public void addPracticedPerennialCropCycleDto(Pz0PracticedPerennialCropCycle pz0PracticedPerennialCropCycle) {
        pz0PracticedPerennialCropCycles.add(pz0PracticedPerennialCropCycle);
    }

    public void addPracticedSeasonalCropCycleDto(Pz0PracticedSeasonalCropCycle pz0PracticedSeasonalCropCycle) {
        pz0PracticedSeasonalCropCycles.add(pz0PracticedSeasonalCropCycle);
        pz0PracticedSeasonalCropCycle.setPracticedSystemId(csvId);
    }

    public void addPrice(Price price) {
        prices.add(price);
    }

    public PracticedSystem getPracticedSystem() {
        return (PracticedSystem) entity;
    }

    public List<Pz0PracticedPerennialCropCycle> getPz0PracticedPerennialCropCycles() {
        return pz0PracticedPerennialCropCycles;
    }

    public List<Pz0PracticedSeasonalCropCycle> getPz0PracticedSeasonalCropCycles() {
        return pz0PracticedSeasonalCropCycles;
    }

    public List<Price> getPrices() {
        return prices;
    }

    public PracticedSystem getEntity() {
        return (PracticedSystem) entity;
    }

    public long getImportedNumber() {
        return importedNumber;
    }

    public String getCsvId() {
        return csvId;
    }
}
