package fr.inra.agrosyst.api.services.pz0.practicedPlot;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedPlotAndDependencies.java 5015 2015-06-25 11:11:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/practicedPlot/PracticedPlotAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;

import java.util.List;

/**
 * Created by davidcosse on 29/01/15.
 */
public class PracticedPlotAndDependencies extends EntityAndDependencies {

    protected List<SolHorizonDto> solHorizonDtos = Lists.newArrayList();
    protected List<String> selectedPlotZoningIds = Lists.newArrayList();
    protected List<String> adjacentElementIds = Lists.newArrayList();

    public PracticedPlotAndDependencies(PracticedPlot entity) {
        super(entity);
    }

    public PracticedPlot getPracticedPlot() {
        return (PracticedPlot) entity;
    }

    protected void addSolHorizonDto(SolHorizonDto solHorizonDto) {
        solHorizonDtos.add(solHorizonDto);
    }

    public void addSelectedPlotZoningIds(String selectedPlotZoningId) {
        selectedPlotZoningIds.add(selectedPlotZoningId);
    }

    public void addAdjacentElementIds(String adjacentElementId) {
        adjacentElementIds.add(adjacentElementId);
    }

    public List<String> getAdjacentElementIds() {
        return adjacentElementIds;
    }

    public PracticedPlot getEntity() {
        return (PracticedPlot) entity;
    }

    public List<SolHorizonDto> getSolHorizonDtos() {
        return solHorizonDtos;
    }

    public List<String> getSelectedPlotZoningIds() {
        return selectedPlotZoningIds;
    }

}
