package fr.inra.agrosyst.api.services.pz0.plot;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PlotAndDependencies.java 5015 2015-06-25 11:11:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/plot/PlotAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Plot;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.growingSystem.GrowingSystemAndDependencies;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by davidcosse on 29/01/15.
 */
public class PlotAndDependencies extends EntityAndDependencies {

    // required
    //protected String domainId;
    protected DomainAndDependencies domainAndDependencies;

    // optional
    //protected String growingSystemId;
    protected GrowingSystemAndDependencies growingSystemAndDependencies;
    protected String locationId;
    protected String selectedSolId;
    protected String selectedSurfaceTextureId;
    protected String selectedSubSoilTextureId;
    protected String selectedSolDepthId;
    protected Collection<String> selectedPlotZoningIds = Lists.newArrayList();
    protected Map<String, Zone> zoneByCsvIds = Maps.newHashMap();
    protected List<SolHorizonDto> solHorizonDtos = Lists.newArrayList();
    protected List<String> adjacentElementIds = Lists.newArrayList();


    public PlotAndDependencies(Plot entity) {
        super(entity);
    }

    public String getDomainId() {
        String result = null;
        if (domainAndDependencies != null && domainAndDependencies.getEntity() != null) {
            result = domainAndDependencies.getEntity().getTopiaId();
        }
        return result;
    }

    public String getGrowingSystemId() {
        String result = growingSystemAndDependencies != null ? growingSystemAndDependencies.getEntity().getTopiaId() : null;
        return result;
    }

    protected void addSolHorizonDto(SolHorizonDto solHorizonDto) {
        solHorizonDtos.add(solHorizonDto);
    }

    public void addSelectedPlotZoningIds(String selectedPlotZoningId) {
        selectedPlotZoningIds.add(selectedPlotZoningId);
    }

    public void addZone(String csvId, Zone zone) {
        zoneByCsvIds.put(csvId, zone);
    }

    public void addSolHorizons(SolHorizonDto solHorizon) {
        solHorizonDtos.add(solHorizon);
    }

    public void addAdjacentElementIds(String adjacentElementId) {
        adjacentElementIds.add(adjacentElementId);
    }

    public List<SolHorizonDto> getSolHorizonDtos() {
        return solHorizonDtos;
    }

    public Map<String, Zone> getZones() {
        return zoneByCsvIds;
    }

    public Collection<String> getSelectedPlotZoningIds() {
        return selectedPlotZoningIds;
    }

    public List<String> getAdjacentElementIds() {
        return adjacentElementIds;
    }

    public Plot getEntity() {
        return (Plot) entity;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getSelectedSolId() {
        return selectedSolId;
    }

    public void setSelectedSolId(String selectedSolId) {
        this.selectedSolId = selectedSolId;
    }

    public String getSelectedSurfaceTextureId() {
        return selectedSurfaceTextureId;
    }

    public void setSelectedSurfaceTextureId(String selectedSurfaceTextureId) {
        this.selectedSurfaceTextureId = selectedSurfaceTextureId;
    }

    public String getSelectedSubSoilTextureId() {
        return selectedSubSoilTextureId;
    }

    public void setSelectedSubSoilTextureId(String selectedSubSoilTextureId) {
        this.selectedSubSoilTextureId = selectedSubSoilTextureId;
    }

    public String getSelectedSolDepthId() {
        return selectedSolDepthId;
    }

    public void setSelectedSolDepthId(String selectedSolDepthId) {
        this.selectedSolDepthId = selectedSolDepthId;
    }

    public void setDomainAndDependencies(DomainAndDependencies domainAndDependencies) {
        this.domainAndDependencies = domainAndDependencies;
    }

    public DomainAndDependencies getDomainAndDependencies() {
        return domainAndDependencies;
    }

    public GrowingSystemAndDependencies getGrowingSystemAndDependencies() {
        return growingSystemAndDependencies;
    }

    public void setGrowingSystemAndDependencies(GrowingSystemAndDependencies growingSystemAndDependencies) {
        this.growingSystemAndDependencies = growingSystemAndDependencies;
    }
}
