package fr.inra.agrosyst.api.services.pz0.growingSystem;

/*
 * #%L
 * Agrosyst :: API
 * $Id: GrowingSystemAndDependencies.java 5015 2015-06-25 11:11:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/growingSystem/GrowingSystemAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;

import java.util.List;

/**
 * Created by davidcosse on 04/12/14.
 */
public class GrowingSystemAndDependencies extends EntityAndDependencies {

    protected String growingPlanPZ0Id;

    protected String refTypeAgricultureId;

    protected List<String> networksId = Lists.newArrayList();

    public GrowingSystemAndDependencies(GrowingSystem entity, String refTypeAgricultureId, String growingPlanPZ0Id) {
        super(entity);
        this.refTypeAgricultureId = refTypeAgricultureId;
        this.growingPlanPZ0Id = growingPlanPZ0Id;
    }

    public void addNetworkToGrowingSystem(String networkId) {
        networksId.add(networkId);
    }

    public String getRefTypeAgricultureId() {
        return refTypeAgricultureId;
    }

    public String getGrowingPlanPZ0Id() {
        return growingPlanPZ0Id;
    }

    public GrowingSystem getGrowingSystem() {
        return (GrowingSystem) entity;
    }

    public List<String> getNetworksId() {
        return networksId;
    }
}
