package fr.inra.agrosyst.api.services.pz0.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0EffectiveSeasonalCropCycle.java 5015 2015-06-25 11:11:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/effective/Pz0EffectiveSeasonalCropCycle.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.exceptions.AgrosystImportException;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;

import java.util.LinkedHashMap;
import java.util.List;

public class Pz0EffectiveSeasonalCropCycle {

    protected String csvId;
    protected EffectiveSeasonalCropCycleDto seasonalCropCycle;

    protected LinkedHashMap<Integer, Pz0EffectiveCropCycleNode> pz0NodesByRank = Maps.newLinkedHashMap();;
    protected List<String> sourceNodeIds = Lists.newArrayList();
    protected List<String> connectionNodeIds = Lists.newArrayList();


    public Pz0EffectiveSeasonalCropCycle(String csvId) {
        this.csvId = csvId;
        this.seasonalCropCycle = new EffectiveSeasonalCropCycleDto();
    }

    public EffectiveSeasonalCropCycleDto getSeasonalCropCycle() {
        return seasonalCropCycle;
    }

    public boolean validNodeUniqueSourceConstraint(String nodeId) {
        boolean result = !sourceNodeIds.contains(nodeId);
        sourceNodeIds.add(nodeId);
        return result;
    }

    public boolean validNodeUniqueTargetConstraint(String nodeId) {
        boolean result = !connectionNodeIds.contains(nodeId);
        connectionNodeIds.add(nodeId);
        return result;
    }

    public void addPz0NodeDto(Pz0EffectiveCropCycleNode pz0NodeDto) throws AgrosystImportException {
        seasonalCropCycle.addNodeDto(pz0NodeDto.getNode());
        pz0NodesByRank.put(pz0NodeDto.getNode().getRank(), pz0NodeDto);
    }

    public EffectiveCropCycleNodeDto getNodeAtRank(int rank) {
        EffectiveCropCycleNodeDto result = null;
        Pz0EffectiveCropCycleNode nodeForRank = pz0NodesByRank.get(rank);
        if (nodeForRank != null) {
            result = nodeForRank.getNode();
        }

        return result;
    }

    public LinkedHashMap<Integer, Pz0EffectiveCropCycleNode> getPz0NodesByRank() {
        return pz0NodesByRank;
    }
}
