package fr.inra.agrosyst.api.services.pz0.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0EffectivePerennialCropCycle.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/effective/Pz0EffectivePerennialCropCycle.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;

import java.util.Map;

/**
 * Created by davidcosse on 22/04/15.
 */
public class Pz0EffectivePerennialCropCycle {

    protected String csvId;
    protected EffectivePerennialCropCycleDto perennialCropCycleDto;
    protected Map<String, Pz0EffectiveCropCyclePhase> phasesByCsvId = Maps.newHashMap();

    public Pz0EffectivePerennialCropCycle(String csvId) {
        this.csvId = csvId;
        this.perennialCropCycleDto = new EffectivePerennialCropCycleDto();
    }

    public void addPz0Phase(Pz0EffectiveCropCyclePhase pz0Phase) {
        phasesByCsvId.put(pz0Phase.getCsvId(), pz0Phase);
        perennialCropCycleDto.addPhase(pz0Phase.getPhase());
    }

    public String getCsvId() {
        return csvId;
    }

    public EffectivePerennialCropCycleDto getPerennialCropCycleDto() {
        return perennialCropCycleDto;
    }

    public Map<String, Pz0EffectiveCropCyclePhase> getPhasesByCsvId() {
        return phasesByCsvId;
    }
}
