package fr.inra.agrosyst.api.services.pz0.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0EffectiveCropCyclePhase.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/effective/Pz0EffectiveCropCyclePhase.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;

import java.util.Map;

/**
 * Created by davidcosse on 13/04/15.
 */
public class Pz0EffectiveCropCyclePhase {

    protected String csvId;

    protected Map<String, Pz0EffectiveIntervention> pz0InterventionByCsvId = Maps.newHashMap();
    protected EffectiveCropCyclePhaseDto phase;
    protected String perennialCropCycleId;

    // related perennial crop object id, useful for intervention validation
    protected String zoneId;
    protected String cropId;

    public Pz0EffectiveCropCyclePhase(String csvId) {
        this.csvId = csvId;
        this.phase = new EffectiveCropCyclePhaseDto();
    }

    public EffectiveCropCyclePhaseDto getPhase() {
        return phase;
    }

    public String getPerennialCropCycleId() {
        return perennialCropCycleId;
    }

    public void setPerennialCropCycleId(String perennialCropCycleId) {
        this.perennialCropCycleId = perennialCropCycleId;
    }

    public Map<String, Pz0EffectiveIntervention> getPz0InterventionByCsvId() {
        return pz0InterventionByCsvId;
    }

    public void addEffectivePz0Intervention(Pz0EffectiveIntervention pz0Intervention) {
        pz0InterventionByCsvId.put(pz0Intervention.getCsvId(), pz0Intervention);
        phase.addIntervention(pz0Intervention.getEffectiveInterventionDto());
    }

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getCropId() {
        return cropId;
    }

    public void setCropId(String cropId) {
        this.cropId = cropId;
    }

    public String getCsvId() {
        return csvId;
    }
}
