package fr.inra.agrosyst.api.services.pz0.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: Pz0EffectiveCropCycleNode.java 5087 2015-09-04 08:31:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/effective/Pz0EffectiveCropCycleNode.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;

import java.util.Map;

/**
 * Created by davidcosse on 13/04/15.
 */
public class Pz0EffectiveCropCycleNode {

    protected String csvId;
    protected EffectiveCropCycleNodeDto node;

    protected String connectionSourceId;

    protected Map<String, Pz0EffectiveIntervention> pz0InterventionByCsvId = Maps.newHashMap();

    protected String effectiveSeasonalCropCycleId;

    public Pz0EffectiveCropCycleNode(String csvId) {
        this.csvId = csvId;
        this.node = new EffectiveCropCycleNodeDto();
    }

    public EffectiveCropCycleNodeDto getNode() {
        return node;
    }


    public String getConnectionSourceId() {
        return connectionSourceId;
    }

    public void setConnectionSourceId(String connectionSourceId) {
        this.connectionSourceId = connectionSourceId;
    }

    public String getEffectiveSeasonalCropCycleId() {
        return effectiveSeasonalCropCycleId;
    }

    public void setEffectiveSeasonalCropCycleId(String effectiveSeasonalCropCycleId) {
        this.effectiveSeasonalCropCycleId = effectiveSeasonalCropCycleId;
    }

    public void addEffectivePz0Intervention(Pz0EffectiveIntervention interventionDto) {
        pz0InterventionByCsvId.put(interventionDto.getCsvId(), interventionDto);
        node.addIntervention(interventionDto.getEffectiveInterventionDto());
    }

    public String getCsvId() {
        return csvId;
    }

    public Map<String, Pz0EffectiveIntervention> getPz0InterventionByCsvId() {
        return pz0InterventionByCsvId;
    }
}
