package fr.inra.agrosyst.api.services.pz0.effective;

/*
 * #%L
 * Agrosyst :: API
 * $Id: EffectiveCropCycleAndDependencies.java 5015 2015-06-25 11:11:10Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/effective/EffectiveCropCycleAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.Price;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;

import java.util.Map;

/**
 * Created by davidcosse on 01/04/15.
 */
public class EffectiveCropCycleAndDependencies extends EntityAndDependencies {

    protected String zoneId;
    protected Map<String, Pz0EffectiveSeasonalCropCycle> effectiveSeasonalCropCyclesByCsvId = Maps.newHashMap();
    protected Map<String, Pz0EffectivePerennialCropCycle> effectivePerennialCropCyclesByCsvId = Maps.newHashMap();
    protected Map<String, Price> prices = Maps.newHashMap();

    protected DomainAndDependencies domainAndDependencies;

    /**
     * This object does not have entity as it belong to there dependencies.
     */
    public EffectiveCropCycleAndDependencies(String zoneId, DomainAndDependencies domainAndDependencies) {
        super(null);
        this.zoneId = zoneId;
        this.domainAndDependencies = domainAndDependencies;
    }

    public void addEffectiveSeasonalCropCycleDto(String id, Pz0EffectiveSeasonalCropCycle seasonalCropCycleDto) {
        effectiveSeasonalCropCyclesByCsvId.put(id, seasonalCropCycleDto);
    }

    public void addEffectivePerennialCropCycleDto(String id, Pz0EffectivePerennialCropCycle perennialCropCycle) {
        effectivePerennialCropCyclesByCsvId.put(id, perennialCropCycle);
    }

    public Pz0EffectiveSeasonalCropCycle getEffectiveSeasonalCropCycleDto(String id) {
        Pz0EffectiveSeasonalCropCycle result = effectiveSeasonalCropCyclesByCsvId.get(id);
        return result;
    }

    public Pz0EffectivePerennialCropCycle getEffectivePerennialCropCycleDto(String id) {
        Pz0EffectivePerennialCropCycle result = effectivePerennialCropCyclesByCsvId.get(id);
        return result;
    }

    public void addPrice(String id, Price price) {
        prices.put(id, price);
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getZoneId() {
        return zoneId;
    }

    public Map<String, Pz0EffectiveSeasonalCropCycle> getEffectivePz0SeasonalCropCyclesByCsvId() {
        return effectiveSeasonalCropCyclesByCsvId;
    }

    public Map<String, Pz0EffectivePerennialCropCycle> getEffectivePz0PerennialCropCyclesByCsvId() {
        return effectivePerennialCropCyclesByCsvId;
    }

    public Map<String, Price> getPrices() {
        return prices;
    }

    public DomainAndDependencies getDomainAndDependencies() {
        return domainAndDependencies;
    }
}
