package fr.inra.agrosyst.api.services.pz0.domains;

/*
 * #%L
 * Agrosyst :: API
 * $Id: DomainAndDependencies.java 5048 2015-07-31 11:55:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/domains/DomainAndDependencies.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 04/12/14.
 */
public class DomainAndDependencies extends EntityAndDependencies {

    protected String csvId;
    protected String csvCode;

    protected long line;
    protected String locationId;
    protected String legalStatusTopiaId;
    protected Integer otex18;
    protected Integer otex70;
    protected Map<String, CroppingPlanEntryDto> croppingPlanEntryDtosByPZ0Code = Maps.newHashMap();
    protected Map<String, CroppingPlanEntryDto> croppingPlanEntryDtosByPZ0CsvId = Maps.newHashMap();
    protected Map<String, CroppingPlanSpeciesDto> croppingPlanSpeciesByCsvId = Maps.newHashMap();
    protected Map<String, CroppingPlanSpeciesDto> croppingPlanSpeciesByCsvCode = Maps.newHashMap();
    protected Map<String, String> croppingPlanSpeciesAgrosystCodeToCsvCode = Maps.newHashMap();

    protected Map<String, String> croppingPlanEntriesAgrosystCodeToCsvCode = Maps.newHashMap();

    protected Set<String> toolsCouplingIds = Sets.newHashSet();
    protected Map<String, ToolsCoupling> toolsCouplingsByCode = Maps.newHashMap();
    protected Map<ToolsCoupling, String> toolsCouplingsToCsvId = Maps.newHashMap();
    protected Map<String, Equipment> equipmentsByCode = Maps.newHashMap();
    protected Map<String, Ground> groundsByCsvId = Maps.newHashMap();


    public DomainAndDependencies(TopiaEntity domain, String locationId, String legalStatusTopiaId, Integer otex18, Integer otex70, String csvId, String csvCode, long line) {
        super(domain);
        this.locationId = locationId;
        this.legalStatusTopiaId = legalStatusTopiaId;
        this.otex18 = otex18;
        this.otex70 = otex70;
        this.csvId = csvId;
        this.csvCode = csvCode;
        this.line = line;
    }

    public void addSpecies(String speciesCsvId, String speciesCsvCode, CroppingPlanSpeciesDto croppingPlanSpeciesDto) {
        croppingPlanSpeciesByCsvId.put(speciesCsvId, croppingPlanSpeciesDto);
        croppingPlanSpeciesByCsvCode.put(speciesCsvCode, croppingPlanSpeciesDto);
        croppingPlanSpeciesAgrosystCodeToCsvCode.put(croppingPlanSpeciesDto.getCode(), speciesCsvCode);
    }

    public CroppingPlanSpeciesDto getSpeciesFromCsvId(String csvId) {
        CroppingPlanSpeciesDto result = croppingPlanSpeciesByCsvId.get(csvId);
        return result;
    }

    public Map<String, CroppingPlanSpeciesDto> getCroppingPlanSpeciesByCsvCode() {
        return croppingPlanSpeciesByCsvCode;
    }

    public void addToolsCoupling(String csvId, ToolsCoupling toolsCoupling) {
        toolsCouplingsByCode.put(toolsCoupling.getCode(), toolsCoupling);
        toolsCouplingsToCsvId.put(toolsCoupling, csvId);
        toolsCouplingIds.add(csvId);
    }

    public void addCroppingPlanEntryDto(String pz0code, String pzId, CroppingPlanEntryDto croppingPlanEntryDto) {
        croppingPlanEntryDtosByPZ0Code.put(pz0code, croppingPlanEntryDto);
        croppingPlanEntryDtosByPZ0CsvId.put(pzId, croppingPlanEntryDto);
        croppingPlanEntriesAgrosystCodeToCsvCode.put(croppingPlanEntryDto.getCode(), pz0code);
    }

    public void addGround(String groundcsvId, Ground ground) {
        groundsByCsvId.put(groundcsvId, ground);
    }

    public Collection<Ground> getGrounds() {
        return groundsByCsvId.values();
    }

    public Ground getGroundForCsvId(String csvId) {
        Ground ground = groundsByCsvId.get(csvId);
        return ground;
    }

    public Domain getDomain() {
        return (Domain) entity;
    }

    public String getCsvId() {
        return csvId;
    }

    public void setCsvId(String csvId) {
        this.csvId = csvId;
    }

    public String getCsvCode() {
        return csvCode;
    }

    public void setCsvCode(String csvCode) {
        this.csvCode = csvCode;
    }

    public String getLocationId() {
        return locationId;
    }

    public String getLegalStatusTopiaId() {
        return legalStatusTopiaId;
    }

    public Integer getOtex18() {
        return otex18;
    }

    public Integer getOtex70() {
        return otex70;
    }

    public Map<String, CroppingPlanEntryDto> getCroppingPlanEntryDtosByPZ0CsvId() {
        return croppingPlanEntryDtosByPZ0CsvId;
    }

    public void addEquipement(Equipment equipment) {
        equipmentsByCode.put(equipment.getCode(), equipment);
    }

    public Map<String, CroppingPlanEntryDto> getCroppingPlanEntryDtosByPZ0Code() {
        return croppingPlanEntryDtosByPZ0Code;
    }

    public String getCsvIdForToolsCouplings(ToolsCoupling toolsCoupling) {
        return toolsCouplingsToCsvId.get(toolsCoupling);
    }

    public Map<String, Equipment> getEquipmentsByCode() {
        return equipmentsByCode;
    }

    public Collection<ToolsCoupling> getToolsCouplings() {
        return toolsCouplingsByCode.values();
    }

    public Collection<Equipment> getEquipments() {
        return equipmentsByCode.values();
    }

    public long getLine() {
        return line;
    }

    public Set<String> getToolsCouplingIds() {
        return toolsCouplingIds;
    }

    public Map<String, String> getCroppingPlanSpeciesAgrosystCodeToCsvCode() {
        return croppingPlanSpeciesAgrosystCodeToCsvCode;
    }

    public Map<String, String> getCroppingPlanEntriesAgrosystCodeToCsvCode() {
        return croppingPlanEntriesAgrosystCodeToCsvCode;
    }
}
