package fr.inra.agrosyst.api.services.pz0;

/*
 * #%L
 * Agrosyst :: API
 * $Id: ImportResults.java 4876 2015-04-01 19:30:31Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/pz0/ImportResults.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by davidcosse on 03/12/14.
 */
public class ImportResults {

    // valid that import can be perform
    boolean importSuccess = true;

    // all entities that have to be persisted and there related dependencies
    Map<String, EntityAndDependencies> entityByCsvIds = Maps.newHashMap();

    // inform about the classes imported
    protected Class importedEntityClass;

    // total of validate Imports
    protected int addedRecords = 0;

    // total of errors that have bean found while parsing the PZ0 csv file
    protected int ignoredRecords = 0;

    // errors messages by csv line
    protected LinkedHashMap<Long, List<String>> errorLineNumbersWithMessage = Maps.newLinkedHashMap();

    // info messages by csv line
    protected LinkedHashMap<Long, List<String>> infoLineNumbersWithMessage = Maps.newLinkedHashMap();

    public void addEntity(String csvId, EntityAndDependencies entity) {
        entityByCsvIds.put(csvId, entity);
    }

    public ImportResults(Class importedEntityClass) {
        this.importedEntityClass = importedEntityClass;
    }


    public void increaseAddedRecords() {
        addedRecords++;
    }

    public void increaseIgnoredRecords() {
        ignoredRecords++;
        importSuccess = false;
    }

    public void addErrorLine(Long lineNumber, String message) {
        List<String> messages = errorLineNumbersWithMessage.get(lineNumber);
        if (messages == null) {
            messages = Lists.newArrayList();
            errorLineNumbersWithMessage.put(lineNumber, messages);
        }
        messages.add(message);
    }

    public void addPostParsingErrorLine(Long lineNumber, String message) {
        List<String> messages = errorLineNumbersWithMessage.get(lineNumber);
        if (messages == null) {
            messages = Lists.newArrayList();
            errorLineNumbersWithMessage.put(lineNumber, messages);
        }
        messages.add(message);
    }

    public void addInfoLine(Long lineNumber, String message) {
        List<String> messages = infoLineNumbersWithMessage.get(lineNumber);
        if (messages == null) {
            messages = Lists.newArrayList();
            infoLineNumbersWithMessage.put(lineNumber, messages);
        }
        messages.add(message);
    }

    public Class getImportedEntityClass() {
        return importedEntityClass;
    }

    public boolean isImportSuccess() {
        return importSuccess;
    }

    public int getAddedRecords() {
        return addedRecords;
    }

    public LinkedHashMap<Long, List<String>> getInfoLineNumbersWithMessage() {
        return infoLineNumbersWithMessage;
    }

    public LinkedHashMap<Long, List<String>>  getErrorLineNumbersWithMessage() {
        return errorLineNumbersWithMessage;
    }

    public int getIgnoredRecords() {
        return ignoredRecords;
    }

    public Map<String, EntityAndDependencies> getEntityAndDepsByCsvIds() {
        return entityByCsvIds;
    }
}
