package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedSystems.java 4970 2015-06-09 11:56:01Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedSystems.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Function;
import fr.inra.agrosyst.api.entities.Entities;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleSpecies;
import fr.inra.agrosyst.api.entities.practiced.PracticedSpeciesStade;
import fr.inra.agrosyst.api.entities.referential.RefClonePlantGrape;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import fr.inra.agrosyst.api.services.itk.Itk;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;

public class PracticedSystems {

    public static final Function<PracticedCropCycleConnection, PracticedCropCycleConnectionDto> CROP_CYCLE_CONNECTION_TO_DTO = new Function<PracticedCropCycleConnection, PracticedCropCycleConnectionDto>() {
        @Override
        public PracticedCropCycleConnectionDto apply(PracticedCropCycleConnection input) {
            PracticedCropCycleConnectionDto result = new PracticedCropCycleConnectionDto();
            result.setSourceId(Entities.ESCAPE_TOPIA_ID.apply(input.getSource().getTopiaId()));
            result.setTargetId(Entities.ESCAPE_TOPIA_ID.apply(input.getTarget().getTopiaId()));
            result.setIntermediateCroppingPlanEntryCode(input.getIntermediateCroppingPlanEntryCode());
            result.setCroppingPlanEntryFrequency(input.getCroppingPlanEntryFrequency());
            result.setNotUsedForThisCampaign(input.isNotUsedForThisCampaign());
            return result;
        }
    };

    public static final Function<PracticedCropCycleNode, PracticedCropCycleNodeDto> CROP_CYCLE_NODE_TO_DTO = new Function<PracticedCropCycleNode, PracticedCropCycleNodeDto>() {
        @Override
        public PracticedCropCycleNodeDto apply(PracticedCropCycleNode input) {
            PracticedCropCycleNodeDto result = new PracticedCropCycleNodeDto();
            result.setNodeId(Entities.ESCAPE_TOPIA_ID.apply(input.getTopiaId()));
            result.setX(input.getRank());
            result.setY(input.getY());
            result.setEndCycle(input.isEndCycle());
            result.setSameCampaignAsPreviousNode(input.isSameCampaignAsPreviousNode());
            result.setCroppingPlanEntryCode(input.getCroppingPlanEntryCode());
            result.setInitNodeFrequency(input.getInitNodeFrequency());
            return result;
        }
    };
    public static final Function<PracticedCropCycleSpecies, String> GET_CROP_CYCLE_PERENNIAL_SPECIES_CODE = new Function<PracticedCropCycleSpecies, String>() {
        @Override
        public String apply(PracticedCropCycleSpecies input) {
            return input.getCroppingPlanSpeciesCode();
        }
    };

    public static final Function<RefVariete, CropCycleGraftDto> REF_VARIETE_TO_GRAPH_DTO = new Function<RefVariete, CropCycleGraftDto>() {

        @Override
        public CropCycleGraftDto apply(RefVariete input) {
            CropCycleGraftDto result = null;
            if (input != null) {
                result = new CropCycleGraftDto();
                result.setTopiaId(input.getTopiaId());
                result.setLabel(input.getLabel());
                result.setValue(input.getLabel());
            }
            return result;
        }
    };

    public static final Function<RefClonePlantGrape, CropCycleGraftDto> REF_CLONE_TO_GRAPH_DTO = new Function<RefClonePlantGrape, CropCycleGraftDto>() {

        @Override
        public CropCycleGraftDto apply(RefClonePlantGrape input) {
            CropCycleGraftDto result = null;
            if (input != null) {
                result = new CropCycleGraftDto();
                result.setTopiaId(input.getTopiaId());
                String label = String.format("%d, %d (%s)", input.getCodeClone(), input.getAnneeAgrement(), input.getOrigine());
                result.setLabel(label);
                result.setValue(label);
            }
            return result;
        }
    };

    public static final Function<PracticedSpeciesStade, SpeciesStadeDto> SPECIES_STADE_TO_DTO = new Function<PracticedSpeciesStade, SpeciesStadeDto>() {
        @Override
        public SpeciesStadeDto apply(PracticedSpeciesStade input) {
            SpeciesStadeDto result = new SpeciesStadeDto();
            result.setTopiaId(input.getTopiaId());

            if (input.getSpeciesCode() != null) {
                result.setSpeciesCode(input.getSpeciesCode());
            }
            result.setStadeMin(Itk.STADE_EDI_TO_DTO.apply(input.getStadeMin()));
            result.setStadeMax(Itk.STADE_EDI_TO_DTO.apply(input.getStadeMax()));
            return result;
        }
    };

}
