package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedSeasonalCropCycleDto.java 4795 2015-02-17 06:32:47Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedSeasonalCropCycleDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycleImpl;

public class PracticedSeasonalCropCycleDto extends PracticedSeasonalCropCycleImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = -7480372706217702916L;

    protected List<PracticedCropCycleNodeDto> cropCycleNodeDtos;

    protected List<PracticedCropCycleConnectionDto> cropCycleConnectionDtos;

    public List<PracticedCropCycleNodeDto> getCropCycleNodeDtos() {
        return cropCycleNodeDtos;
    }

    public void setCropCycleNodeDtos(List<PracticedCropCycleNodeDto> cropCycleNodeDtos) {
        this.cropCycleNodeDtos = cropCycleNodeDtos;
    }

    public List<PracticedCropCycleConnectionDto> getCropCycleConnectionDtos() {
        return cropCycleConnectionDtos;
    }

    public void setCropCycleConnectionDtos(List<PracticedCropCycleConnectionDto> cropCycleConnectionDtos) {
        this.cropCycleConnectionDtos = cropCycleConnectionDtos;
    }

    public void addNode(PracticedCropCycleNodeDto node) {
        if (cropCycleNodeDtos == null) {
            cropCycleNodeDtos = Lists.newArrayList();
        }
        cropCycleNodeDtos.add(node);
    }

    public void addConnection(PracticedCropCycleConnectionDto connection) {
        if (cropCycleConnectionDtos == null) {
            cropCycleConnectionDtos = Lists.newArrayList();
        }
        cropCycleConnectionDtos.add(connection);
    }

}
