package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedPlotService.java 4855 2015-03-23 17:56:42Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedPlotService.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.NavigationContext;
import fr.inra.agrosyst.api.entities.practiced.PracticedPlot;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.AgrosystService;
import fr.inra.agrosyst.api.services.ResultList;
import fr.inra.agrosyst.api.services.plot.SolHorizonDto;
import fr.inra.agrosyst.api.services.pz0.ImportResults;

import java.util.List;
import java.util.Map;

/**
 * Practiced plot service.
 * 
 * @author Eric Chatellier
 */
public interface PracticedPlotService extends AgrosystService  {

    ResultList<PracticedPlot> getFilteredPracticedPlots(PracticedPlotFilter filter);

    /**
     * return the practiced plot matching the given filter parameters
     * @param filter filter por practiced plot
     * @return the practiced plot matching filter
     */
    ResultList<PracticedPlotDto> getFilteredPracticedPlotsDto(PracticedPlotFilter filter);

    /**
     * Return the instance of plot for the given practicedPlotTopiaId, if null a new instance is created.
     * @param practicedPlotTopiaId the id of requested practiced plot, if null a new instance is created
     * @return a practiced plot
     */
    PracticedPlot getPracticedPlot(String practicedPlotTopiaId);

    /**
     * Create or update the given practiced plot
     * @param practicedPlot the practiced plot to create or update, it must have the following attributes not null: name, waterFlowDistance, bufferStrip, maxSlope
     * @param practicedSystemTopiaId the id of the practiced system related to the practiced plot (can not be null)
     * @param locationTopiaId the id of location (can not be null)
     * @param selectedSurfaceTextureId the related surface texture
     * @param selectedSubSoilTextureId the related sub surface texture
     * @param selectedSolDepthId the sol depth id
     * @param selectedPlotZoningIds  the ids of related zones (can not be null)
     * @param solHorizons  the sol horizon ids
     * @param adjacentElementIds the adjacent elements ids
     * @return the persisted Practiced Plots
     */
    PracticedPlot createOrUpdatePracticedPlot(PracticedPlot practicedPlot, String practicedSystemTopiaId,
                                              String locationTopiaId, String selectedSurfaceTextureId,
                                              String selectedSubSoilTextureId, String selectedSolDepthId,
                                              List<String> selectedPlotZoningIds,
                                              List<SolHorizonDto> solHorizons,
                                              List<String> adjacentElementIds);

    /**
     * Return Practiced Systems not related to Practiced Plot
     * @param navigationContext the navigation context
     * @return all practiced systems without practiced plot
     */
    List<PracticedSystem> getPracticedSystemsWithoutPracticedPlot(NavigationContext navigationContext);

    /**
     * Save the practiced plot imported from PZ0
     * @param allResults contain valid practiced plots
     */
    void importPZ0PracticedPlots(Map<Class, ImportResults> allResults);

}
