package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedPlotDto.java 3963 2014-04-02 09:42:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedPlotDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.Serializable;

/**
 * @author Arnaud Thimel (Code Lutin)
 */
public class PracticedPlotDto implements Serializable {

    private static final long serialVersionUID = 8381750560964714581L;

    protected String topiaId;
    protected String name;
    protected PracticedSystemDto practicedSystem;

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PracticedSystemDto getPracticedSystem() {
        return practicedSystem;
    }

    public void setPracticedSystem(PracticedSystemDto practicedSystem) {
        this.practicedSystem = practicedSystem;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PracticedPlotDto other = (PracticedPlotDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
