package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedPerennialCropCycleDto.java 4863 2015-03-25 23:31:00Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedPerennialCropCycleDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;

import java.io.Serializable;
import java.util.List;

public class PracticedPerennialCropCycleDto implements Serializable {

    private static final long serialVersionUID = -3827956420687189759L;

    protected PracticedPerennialCropCycle practicedPerennialCropCycle;

    protected List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos;

    protected List<String> croppingPlanSpeciesIds;

    protected List<PracticedCropCycleSpeciesDto> speciesDto;

    protected String croppingPlanEntryName;

    public List<PracticedCropCyclePhaseDto> getCropCyclePhaseDtos() {
        return cropCyclePhaseDtos;
    }

    public void setCropCyclePhaseDtos(List<PracticedCropCyclePhaseDto> cropCyclePhaseDtos) {
        this.cropCyclePhaseDtos = cropCyclePhaseDtos;
    }

    public void addCropCyclePhaseDtos(PracticedCropCyclePhaseDto cropCyclePhaseDto) {
        if (cropCyclePhaseDtos == null) {
            cropCyclePhaseDtos = Lists.newArrayList();
        }
        cropCyclePhaseDtos.add(cropCyclePhaseDto);
    }

    public List<String> getCroppingPlanSpeciesIds() {
        return croppingPlanSpeciesIds;
    }

    public void setCroppingPlanSpeciesIds(List<String> croppingPlanSpeciesIds) {
        this.croppingPlanSpeciesIds = croppingPlanSpeciesIds;
    }

    public void addCroppingPlanSpeciesIds(String croppingPlanSpeciesId) {
        if (croppingPlanSpeciesIds == null) {
            croppingPlanSpeciesIds = Lists.newArrayList();
        }
        croppingPlanSpeciesIds.add(croppingPlanSpeciesId);
    }

    public List<PracticedCropCycleSpeciesDto> getSpeciesDto() {
        return speciesDto;
    }

    public void setSpeciesDto(List<PracticedCropCycleSpeciesDto> speciesDto) {
        this.speciesDto = speciesDto;
    }

    public void addSpeciesDto(PracticedCropCycleSpeciesDto species) {
        if (speciesDto == null) {
            speciesDto = Lists.newArrayList();
        }
        speciesDto.add(species);
    }

    public PracticedPerennialCropCycle getPracticedPerennialCropCycle() {
        return practicedPerennialCropCycle;
    }

    public void setPracticedPerennialCropCycle(PracticedPerennialCropCycle practicedPerennialCropCycle) {
        this.practicedPerennialCropCycle = practicedPerennialCropCycle;
    }

    public String getCroppingPlanEntryName() {
        return croppingPlanEntryName;
    }

    public void setCroppingPlanEntryName(String croppingPlanEntryName) {
        this.croppingPlanEntryName = croppingPlanEntryName;
    }
}
