package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedInterventionDto.java 4772 2015-02-06 11:25:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedInterventionDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.practiced.PracticedInterventionImpl;
import fr.inra.agrosyst.api.services.itk.SpeciesStadeDto;

import java.util.List;

/**
 * @author cosse
 */
public class PracticedInterventionDto extends PracticedInterventionImpl {

    private static final long serialVersionUID = -5097743982791358800L;

    // Identifiant du domaine sur lequel porte l'intervention.
    // L'identifiant peut-être soit le TopiaId du domaine soit son code
    // celon qu'il s'agit d'une intervention du réalisé ou synthétisé.
    protected String domainId;

    protected List<AbstractAction> actions;

    protected List<AbstractInput> inputs;

    protected List<SpeciesStadeDto> speciesStadesDtos;

    public String getDomainId() {
        return domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public List<AbstractAction> getActions() {
        return actions;
    }

    public void setActions(List<AbstractAction> actions) {
        this.actions = actions;
    }

    public List<AbstractInput> getInputs() {
        return inputs;
    }

    public void setInputs(List<AbstractInput> inputs) {
        this.inputs = inputs;
    }

    public List<SpeciesStadeDto> getSpeciesStadesDtos() {
        return speciesStadesDtos;
    }

    public void setSpeciesStadesDtos(List<SpeciesStadeDto> speciesStadesDtos) {
        this.speciesStadesDtos = speciesStadesDtos;
    }

    public void addAction(AbstractAction abstractAction) {
        if (actions == null) {
            actions = Lists.newArrayList();
        }
        actions.add(abstractAction);
    }

    public void addInput(AbstractInput input) {
        if (inputs == null) {
            inputs = Lists.newArrayList();
        }
        inputs.add(input);
    }

    public void addSpeciesStadeDto(SpeciesStadeDto speciesStadeDto) {
        if (speciesStadesDtos == null) {
            speciesStadesDtos = Lists.newArrayList();
        }
        speciesStadesDtos.add(speciesStadeDto);
    }

    public void addToolsCouplingCode(String toolsCouplingCode) {
        if (toolsCouplingCodes == null) {
            toolsCouplingCodes = Lists.newArrayList();
        }
        toolsCouplingCodes.add(toolsCouplingCode);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((topiaId == null) ? 0 : topiaId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PracticedInterventionDto other = (PracticedInterventionDto) obj;
        if (topiaId == null) {
            if (other.topiaId != null)
                return false;
        } else if (!topiaId.equals(other.topiaId))
            return false;
        return true;
    }
}
