package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedCropCycleSpeciesDto.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedCropCycleSpeciesDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.Date;

import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;

/**
 * Dto corresponding to {@code PracticedCropCycleSpecies} entity.
 * 
 * @author Eric Chatellier
 */
public class PracticedCropCycleSpeciesDto extends CroppingPlanSpeciesDto {

    private static final long serialVersionUID = 4673587209266382992L;

    protected boolean plantCertified;
    protected Date overGraftDate;

    protected CropCycleGraftDto graftSupport;
    protected CropCycleGraftDto graftClone;

    public PracticedCropCycleSpeciesDto() {
    }

    public PracticedCropCycleSpeciesDto(CroppingPlanSpeciesDto parent) {
        this.topiaId = parent.getTopiaId();
        this.code = parent.getCode();

        this.speciesId = parent.getSpeciesId();
        this.speciesEspece = parent.getSpeciesEspece();
        this.speciesQualifiant = parent.getSpeciesQualifiant();
        this.speciesTypeSaisonnier = parent.getSpeciesTypeSaisonnier();
        this.speciesDestination = parent.getSpeciesDestination();

        this.varietyId = parent.getVarietyId();
        this.varietyLibelle = parent.getVarietyLibelle();
        this.profil_vegetatif_BBCH = parent.getProfil_vegetatif_BBCH();
    }

    public CropCycleGraftDto getGraftSupport() {
        return graftSupport;
    }

    public void setGraftSupport(CropCycleGraftDto graftSupport) {
        this.graftSupport = graftSupport;
    }

    public CropCycleGraftDto getGraftClone() {
        return graftClone;
    }

    public void setGraftClone(CropCycleGraftDto graftClone) {
        this.graftClone = graftClone;
    }

    public boolean isPlantCertified() {
        return plantCertified;
    }

    public void setPlantCertified(boolean plantCertified) {
        this.plantCertified = plantCertified;
    }

    public Date getOverGraftDate() {
        return overGraftDate;
    }

    public void setOverGraftDate(Date overGraftDate) {
        this.overGraftDate = overGraftDate;
    }

}
