package fr.inra.agrosyst.api.services.practiced;

/*
 * #%L
 * Agrosyst :: API
 * $Id: PracticedCropCyclePhaseDto.java 4875 2015-03-31 16:27:46Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-api/src/main/java/fr/inra/agrosyst/api/services/practiced/PracticedCropCyclePhaseDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseImpl;

import java.util.List;

/**
 * Cycle phase dto corresponding to CropCyclePhaseImpl.
 * Defined just to not manipulate Impl in code.
 * 
 * @author Eric Chatellier
 */
public class PracticedCropCyclePhaseDto extends PracticedCropCyclePhaseImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8187559411236982205L;

    protected List<PracticedInterventionDto> interventions;

    public List<PracticedInterventionDto> getInterventions() {
        return interventions;
    }

    public void setInterventions(List<PracticedInterventionDto> interventions) {
        this.interventions = interventions;
    }

    public void addIntervention(PracticedInterventionDto interventionDto) {
        if (interventions == null) {
            interventions = Lists.newArrayList();
        }
        interventions.add(interventionDto);
    }

}
